/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.plugins.contentio.synchronize.impl.DefaultSynchronizingContentOperator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class UDOrgUnitTypeOperator
extends DefaultSynchronizingContentOperator
implements Serviceable {
    protected static final String UDORGUNIT_TYPE_CONTENT_TYPE = "org.ametys.plugins.userdirectory.Content.udorgunitType";
    protected static final String UDORGUNIT_ATTRIBUTE_TYPE = "type";
    protected static final String UDORGUNIT_TYPE_ATTRIBUTE_CODE = "code";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map<String, List<Object>> transform(ContentType cType, Map<String, List<Object>> remoteValues, Logger logger) {
        if (remoteValues.containsKey(UDORGUNIT_ATTRIBUTE_TYPE)) {
            HashMap<String, List<Object>> transformedValues = new HashMap<String, List<Object>>(remoteValues);
            ArrayList<Content> contents = new ArrayList<Content>();
            List<Object> typeCodes = remoteValues.get(UDORGUNIT_ATTRIBUTE_TYPE);
            for (Object typeCode : typeCodes) {
                Content udorgUnitTypeContent = this._getOrgUnitTypeFromCode(String.valueOf(typeCode));
                if (udorgUnitTypeContent != null) {
                    contents.add(udorgUnitTypeContent);
                    continue;
                }
                logger.warn("The code '{}' does not have a corresponding UDOrgunit Type content. It will be ignored.", typeCode);
            }
            transformedValues.put(UDORGUNIT_ATTRIBUTE_TYPE, contents);
            return transformedValues;
        }
        return remoteValues;
    }

    protected Content _getOrgUnitTypeFromCode(String code) {
        ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{UDORGUNIT_TYPE_CONTENT_TYPE});
        StringExpression codeExpr = new StringExpression(UDORGUNIT_TYPE_ATTRIBUTE_CODE, Expression.Operator.EQ, code);
        String xpathQuery = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{cTypeExpr, codeExpr}));
        return this._resolver.query(xpathQuery).stream().findFirst().orElse(null);
    }
}

