/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.web.repository.page.Page;

/**
 * Invalidates the ZoneItem containing a Content which has just been modified or synchronized.
 */
public class InvalidateZoneItemCacheOnContentModificationObserver extends AbstractContentObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_CONTENT_MODIFIED)
                || event.getId().equals(org.ametys.plugins.contentio.synchronize.observation.ObservationConstants.EVENT_CONTENT_SYNCHRONIZED);
    }

    public int getPriority()
    {
        // processed just before front-office cache invalidation
        return MAX_PRIORITY + 3500;
    }

    @Override
    protected void _internalObserve(Event event, Page rootPage, Content content)
    {
        _removeZoneItemCache(rootPage, content, "default");
    }

}
