/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.userdirectory.page.OrganisationChartPageResolver;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.web.indexing.solr.SolrPageIndexer;
import org.ametys.web.repository.page.Page;

/**
 * Abstract {@link Observer} for synchronizing the Solr indexes.
 *
 */
public abstract class AbstractSolrContentObserver extends AbstractContentObserver implements IndexingObserver
{
    /** The Solr page indexer. */
    protected SolrPageIndexer _solrPageIndexer;
    
    /** The user directory page resolver */
    protected UserDirectoryPageResolver _uDPageResolver;
    
    /** The organisation chart page resolver */
    protected OrganisationChartPageResolver _oCPageResolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _solrPageIndexer = (SolrPageIndexer) manager.lookup(SolrPageIndexer.ROLE);
        _uDPageResolver = (UserDirectoryPageResolver) manager.lookup(UserDirectoryPageResolver.ROLE);
        _oCPageResolver = (OrganisationChartPageResolver) manager.lookup(OrganisationChartPageResolver.ROLE);
    }

    @Override
    public int getPriority()
    {
        // Will be processed after live synchronization observers
        return MAX_PRIORITY + 3000;
    }
    
    /**
     * Get content page
     * @param rootContentPage the root content page
     * @param content the content
     * @return the content page
     */
    protected Page _getContentPage(Page rootContentPage, Content content)
    {
        if (_isUserContent(content))
        {
            return _uDPageResolver.getUserPage(rootContentPage, content);
        }
        else if (_isOrgUnitContent(content))
        {
            return _oCPageResolver.getOrgUnitPage(rootContentPage, content);
        }
        
        return null;
    }
}
