<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                exclude-result-prefixes="docbook"
                extension-element-prefixes="resolver ametys user math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">organization-chart</xsl:variable>

    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="maxLevel" select="string(ametys:serviceParameter('maxLevel')/text())"/>
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:pluginResourceURL('user-directory', 'css/services/organization-chart-vertical.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="organization-chart-js"/>
    </xsl:template>
    
    <xsl:template name="organization-chart-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('web', 'js/utils/base64.js')}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('user-directory', 'js/organization-chart-vertical.js')}"></script>
        <script type="text/javascript">
            $j(document).ready(function () {
                AmetysOrganizationChart.initialize('.organization-chart', '<xsl:value-of select="$site-uri-prefix"/>', '<xsl:value-of select="$site"/>', '<xsl:call-template name="orgunit-view-name"/>');
            });
        </script>
        <script>
            $j(document).ready(function () {
                var $form = $j('.organization-chart .searchOrga');
                var $searchInput = $form.find('input');
                var searchInputHeight = $searchInput.outerHeight();

                // position dropdown search result 3px under search input
                var topPosition = $searchInput.offset().top - $form.offset().top + searchInputHeight + 3;

                $j('.organization-chart .results').css('top', topPosition);
                
                // Move overlay and popup to body
                $j('.organization-chart .overlay').appendTo(document.body);
                $j('.organization-chart [role=dialog]').appendTo(document.body);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="orgunit-view-name">main</xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template> 
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="orgunit-chart-search-form"/>
        <xsl:call-template name="orgunit-chart"/>
    </xsl:template>
    
    <xsl:template name="orgunit-chart-search-form">
        <form class="searchOrga" onsubmit="return false;">
            <div class="field search second">
                <input type="text" id="search" class="second" onkeyup="AmetysOrganizationChart.searchOrga()" placeholder="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_SERVICE_SEARCH" aria-label="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_SERVICE_SEARCH_ARIA_LABEL" i18n:attr="placeholder aria-label" />
            </div>
            <div class="results"></div>
        </form>
    </xsl:template>
    
    <xsl:template name="orgunit-chart">
        <div class="container-orga">
            <div class="left">
                <ul class="orga open display-as-line">
                    <xsl:apply-templates select="orgUnit">
                        <xsl:with-param name="level" select="'1'"/>
                    </xsl:apply-templates>
                </ul>
                <div class="blank-mobile"></div>
            </div>
            
            <div class="overlay orga" onclick="AmetysOrganizationChart.closeOrgaUnit()"></div>
            
            <div class="ametys-cms-content orgunit view-organizationChart" role="dialog" aria-modal="true">
                <button class="close" onclick="AmetysOrganizationChart.closeOrgaUnit()" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_SERVICE_CLOSE" i18n:attr="title"><i class="fas fa-times" aria-hidden="true"></i></button>
                <div class="container">
                    <div data-ametys-orgunit="true"></div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="orgUnit">
        <xsl:param name="level"/>
        
        <li id="orgunit-{generate-id()}" style="max-width: none;">
            <xsl:if test="$level = 1">
                <xsl:attribute name="class">level-1-orga</xsl:attribute>
            </xsl:if>
            
            <div class="item">
                <div class="item-content" data-ametys-content-id="{@id}" tabindex="0" role="button" aria-haspopup="modal">
                    <div class="top">
                        <xsl:apply-templates select="." mode="image"/>
                        <xsl:apply-templates select="." mode="title"/>
                    </div>
                
                    <xsl:apply-templates select="main-user"/>
                </div>

                <xsl:apply-templates select="." mode="open"/>
            </div>
            
            <xsl:if test="orgUnits/orgUnit">
                <ul class="display-as-line">
                    <xsl:apply-templates select="orgUnits/orgUnit">
                        <xsl:with-param name="level" select="$level + 1"></xsl:with-param>
                    </xsl:apply-templates>
                </ul>
            </xsl:if>
        </li>                
    </xsl:template>
    
    <xsl:template match="orgUnit" mode="image">
        <div class="picto">
            <xsl:variable name="login" select="main-user/html/head/meta[@name = 'user;login']/@content"/>
            <xsl:variable name="populationId" select="main-user/html/head/meta[@name = 'user;populationId']/@content"/>
            
            <xsl:choose>
                <xsl:when test="$login">
                    <img src="{concat($site-uri-prefix, '/_plugins/core-ui/user/', $populationId, '/', uriutils:encodePath($login), '/image_61', '?lang=', $lang)}" alt=""/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="orgunit-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="orgunit-default-image">
        <img src="{ametys:pluginResourceURL('user-directory', 'img/orgunit.png')}" width="61px" height="61px" alt=""/>
    </xsl:template>
    
    <xsl:template match="orgUnit" mode="title">
        <span class="title searchable"><xsl:value-of select="html/head/meta[@name = 'title']/@content" /></span>
    </xsl:template>
    
    <xsl:template match="orgUnit" mode="open">
        <xsl:variable name="childrenSize" select="count(orgUnits/orgUnit)"></xsl:variable>
        <xsl:variable name="i18nparams"><count><xsl:value-of select="$childrenSize"/></count></xsl:variable> 
        <xsl:variable name="i18nkey">
            <xsl:choose>
                <xsl:when test="$childrenSize > 1">plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_SERVICE_EXPAND_ORGA_MULTIPLE</xsl:when>
                <xsl:otherwise>plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_SERVICE_EXPAND_ORGA</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <xsl:if test="$childrenSize > 0">
            <button class="link open-orga" aria-expanded="false" type="button">
               <xsl:attribute name="title">
                  <xsl:value-of select="ametys:translate($i18nkey, $lang, $i18nparams)"/>
               </xsl:attribute>
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="ametys:translate($i18nkey, $lang, $i18nparams)"/>
               </xsl:attribute>
               <xsl:value-of select="$childrenSize"/>
               <i class="fas fa-chevron-down" aria-hidden="true"></i>
           </button>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="main-user">
        <div class="bottom">
            <span class="name searchable">
                <xsl:value-of select="html/head/meta[@name = 'title']/@content" />
            </span>
        
            <xsl:if test="role">
                <div class="function searchable">
                    <xsl:value-of select="role" />
                </div>
            </xsl:if>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
