<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                extension-element-prefixes="ametys math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('user-directory', 'js/organization-chart.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:pluginResourceURL('user-directory', 'css/services/organization-chart.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="maxLevel" select="string(ametys:serviceParameter('maxLevel')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">organization-chart</xsl:variable>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template> 
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:variable name="level">1</xsl:variable>
        
        <ul class="chart-no-focus orgunits-level-{$level}">
            <xsl:apply-templates select="orgUnit">
                <xsl:with-param name="level" select="$level"/>
            </xsl:apply-templates>
        </ul>
    </xsl:template>

    <xsl:template match="orgUnits" mode="children">
        <xsl:param name="level"/>
		<ul class="orgunits-level-{$level}">
		    <xsl:apply-templates select="orgUnit">
		        <xsl:with-param name="level" select="$level"/>
		    </xsl:apply-templates>
		</ul>
    </xsl:template>
    
    <xsl:template match="orgUnit">
        <xsl:param name="level"/>
        <li>
	        <xsl:if test="orgUnits">
                <input class="checkbox" type="checkbox" id="{generate-id()}">
                    <xsl:if test="not($maxLevel) or $level &lt; $maxLevel">
                        <xsl:attribute name="checked" />
                    </xsl:if>
                </input>
            </xsl:if>
	        
	        <div>
		        <xsl:call-template name="orgUnit-focus" >
		          <xsl:with-param name="level" select="$level" />
		        </xsl:call-template>

                <xsl:copy-of select="html/body/node()" />
    	        <xsl:call-template name="main-user"/>
    	        <xsl:if test="orgUnits">
	                <label for="{generate-id()}"><span><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_TOGGLE_LABEL" i18n:catalogue="plugin.user-directory"/></span></label>
	            </xsl:if>
    	    </div>

            <xsl:apply-templates select="orgUnits" mode="children">
                <xsl:with-param name="level" select="$level + 1"/>
            </xsl:apply-templates>
        </li>
    </xsl:template>
    
    <xsl:template name="main-user" >
        <xsl:if test="main-user">
            <div class="main-user">
				<xsl:copy-of select="main-user/html/body/node()" />
				<div class="role">
				    <xsl:value-of select="main-user/role" />
				</div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="orgUnit-focus">
        <xsl:param name="level" />
        <xsl:if test="$level != 1">
	        <div class="orgUnit-focus">
	            <a href="#" onclick="try{{AmetysOrganizationChart._focusOrgunit(this)}}finally{{return false;}}" data-orgunit-id="ud-{@unique-id}" class="focus" i18n:attr="title" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_FOCUS_TOOLTIP">
	                <span><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_FOCUS_MSG" i18n:catalogue="plugin.user-directory"/></span>
	            </a>
	            <a href="#" onclick="try{{AmetysOrganizationChart._backToParent(this)}}finally{{return false;}}" data-orgunit-id="ud-{@unique-id}" style="display:none" class="back-to-parent" i18n:attr="title" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_BACK_TO_PARENT_TOOLTIP">
	                <span><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_BACK_TO_PARENT_MSG" i18n:catalogue="plugin.user-directory"/></span>
	            </a>
	            <a href="#" onclick="try{{AmetysOrganizationChart._removeFocus()}}finally{{return false;}}" style="display:none" class="remove-focus" i18n:attr="title" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_REMOVE_FOCUS_TOOLTIP">
	                <span><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_REMOVE_FOCUS_MSG" i18n:catalogue="plugin.user-directory"/></span>
	            </a>
	        </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
