/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.service.search;

import java.util.function.Function;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.search.query.Query;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.impl.PrivateContentReturnable;

/**
 * {@link Returnable} for users' contents
 *
 */
public class UserContentReturnable extends PrivateContentReturnable
{
    /** The additional parameter for the view */
    public static final String PARAMETER_VIEW = "userContentView";
    
    @Override
    protected String getViewForSax(AdditionalParameterValueMap additionalParameterValues)
    {
        return StringUtils.defaultIfEmpty(additionalParameterValues.getValue(PARAMETER_VIEW), "main");
    }
    
    @Override
    protected Function<Query, Query> siteQueryJoiner()
    {
        // User contents are created through plugin content-io, and are "off-site". 
        return null;
    }
}
