/**
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 
const rootQuery = "//element(*, ametys:page)[@ametys-internal:virtual = 'org.ametys.plugins.userdirectory.page.VirtualOrganisationChartPageFactory']"
const servicesQuery = "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugins.userdirectory.service.OrganizationChart']";
 

migrateOrgUnitRootPages(Repository.session);
migrateOrgUnitRootPages(Repository.liveSession);

migrateOrganizationChartServices(Repository.session);
migrateOrganizationChartServices(Repository.liveSession);

function migrateOrgUnitRootPages(session)
{
    let nodes = Repository.query(rootQuery, false, session);
    
    while (nodes.hasNext())
    {
        let node = nodes.next();
        node.setProperty("ametys:organisation-chart-root-contenttype", "org.ametys.plugins.userdirectory.Content.udorgunit");
    }
    
    session.save();
}

function migrateOrganizationChartServices(session)
{
    let nodes = Repository.query(servicesQuery, false, session);
    
    while (nodes.hasNext())
    {
        let zoneItem = nodes.next();
        let params = zoneItem.getNode("ametys:service_parameters");
        params.setProperty("ametys:content-type", "org.ametys.plugins.userdirectory.Content.udorgunit");
    }
    
    session.save();
}

