/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

/**
 * Observation constants for User Directory plugin
 */
public interface ObservationConstants
{
    /** Event id when a user directory root page is being deleted. */
    public static final String EVENT_USER_DIRECTORY_ROOT_DELETING = "user.directory.root.deleting";
    /** Event id when a user directory root page is deleted. */
    public static final String EVENT_USER_DIRECTORY_ROOT_DELETED = "user.directory.root.deleted";
    /** Event id when a user directory root page is being updated. */
    public static final String EVENT_USER_DIRECTORY_ROOT_UPDATING = "user.directory.root.updating";
    /** Event id when a user directory root page is updated. */
    public static final String EVENT_USER_DIRECTORY_ROOT_UPDATED = "user.directory.root.updated";
    /** Event id when a user directory page is changed. */
    public static final String EVENT_USER_DIRECTORY_ROOT_CHANGED = "user.directory.root.changed";
    
    /** Event id when a organisation chart root page is being deleted. */
    public static final String EVENT_ORGANISATION_CHART_ROOT_DELETING = "organisation.chart.root.deleting";
    /** Event id when a organisation chart root page is deleted. */
    public static final String EVENT_ORGANISATION_CHART_ROOT_DELETED = "organisation.chart.root.deleted";
    /** Event id when a organisation chart root page is being updated. */
    public static final String EVENT_ORGANISATION_CHART_ROOT_UPDATING = "organisation.chart.root.updating";
    /** Event id when a organisation chart root page is updated. */
    public static final String EVENT_ORGANISATION_CHART_ROOT_UPDATED = "organisation.chart.root.updated";
    /** Event id when a organisation chart page is changed. */
    public static final String EVENT_ORGANISATION_CHART_ROOT_CHANGED = "organisation.chart.root.changed";
    
    /** Argument's name for update of user content view */
    public static final String ARGS_USER_CONTENT_VIEW_UPDATED = "user.content.view.updated";
}
