/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.page;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;

/**
 * Common class for factories of User Directory virtual pages
 */
public abstract class AbstractUserDirectoryPageFactory extends AbstractConfigurableVirtualPageFactory
{
    /** The synchronizable contents collection DAO */
    protected SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    /** The user directory page handler*/
    protected UserDirectoryPageHandler _userDirectoryPageHandler;

    
    @Override
    public void deferredService(ServiceManager manager) throws ServiceException
    {
        super.deferredService(manager);

        _userDirectoryPageHandler = (UserDirectoryPageHandler) manager.lookup(UserDirectoryPageHandler.ROLE);
        _synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO) manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
    }
    
    /**
     * Get the user directory page handler
     * @return The <code>UserDirectoryPageHandler</code>
     */
    public UserDirectoryPageHandler getUserDirectoryPageHandler()
    {
        return _userDirectoryPageHandler;
    }
    
    /**
     * Get the synchronizable contents collection DAO
     * @return The <code>SynchronizableContentsCollectionDAO</code> 
     */
    public SynchronizableContentsCollectionDAO getSynchronizableContentsCollectionDAO()
    {
        return _synchronizableContentsCollectionDAO;
    }
    
    /**
     * Get the org unit page factory
     * @return The <code>OrgUnitPageFactory</code>
     */
    protected OrgUnitPageFactory getOrgUnitPageFactory()
    {
        return (OrgUnitPageFactory) _ametysObjectFactoryEP.getExtension(OrgUnitPageFactory.class.getName());
    }
    
    /**
     * Get the transitional page factory
     * @return The <code>TransitionalPageFactory</code>
     */
    protected TransitionalPageFactory getTransitionalPageFactory()
    {
        return (TransitionalPageFactory) _ametysObjectFactoryEP.getExtension(TransitionalPageFactory.class.getName());
    }
    
    /**
     * Get the user page factory
     * @return The <code>UserPageFactory</code>
     */
    protected UserPageFactory getUserPageFactory()
    {
        return (UserPageFactory) _ametysObjectFactoryEP.getExtension(UserPageFactory.class.getName());
    }
}
