/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.rights;

import java.util.Collections;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.rights.ContentRightAssignmentContext;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;

/**
 * {@link RightAssignmentContext} for assign rights to a user directory {@link Content}
 */
public class UserDirectoryRightAssignmentContext extends ContentRightAssignmentContext
{
    /** The right assignement context id */
    @SuppressWarnings("hiding")
    public static final String ID = "org.ametys.plugins.userdirectory.right.assignment.context";
    /** The user directory helper */
    protected UserDirectoryHelper _userDirectoryHelper;
    
    /** The organisation chart page handler */
    protected OrganisationChartPageHandler _organisationChartPageHandler;
    
    /** The content type helper */
    protected ContentTypesHelper _contentTypeHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _userDirectoryHelper = (UserDirectoryHelper) smanager.lookup(UserDirectoryHelper.ROLE);
        _organisationChartPageHandler = (OrganisationChartPageHandler) smanager.lookup(OrganisationChartPageHandler.ROLE);
        _contentTypeHelper = (ContentTypesHelper) smanager.lookup(ContentTypesHelper.ROLE);
    }
    
    @Override
    public Set<Object> getParentContexts(Object context)
    {
        if (context instanceof Content)
        {
            Content content = (Content) context;
            if (_contentTypeHelper.isInstanceOf(content, UserDirectoryHelper.ORGUNIT_CONTENT_TYPE))
            {
                return Collections.singleton(_organisationChartPageHandler.getParentContent(content));
            }
        }
        
        return super.getParentContexts(context);
    }
    
    @Override
    protected Object getRootContent()
    {
        return _userDirectoryHelper.getUserDirectoryRootContent(true);
    }

}
