/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.sitemap;

import java.util.Arrays;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.page.VirtualUserDirectoryPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.sitemap.AbstractStaticSitemapIndicator;
import org.ametys.web.sitemap.SitemapTreeIndicator;

/**
 * {@link SitemapTreeIndicator} for UD root page
 */
public class UserDirectoryRootSitemapIndicator extends AbstractStaticSitemapIndicator 
{
    public boolean matches(SitemapElement sitemapElement)
    {
        if (sitemapElement instanceof Page page && page instanceof JCRAmetysObject jcrPage)
        {
            if (_isUserDirectoryRootPage(jcrPage))
            {
                return true;
            }
        }
        return false;
    }
    
    private boolean _isUserDirectoryRootPage (JCRAmetysObject jcrPage)
    {
        try
        {
            Node node = jcrPage.getNode();
            
            if (node.hasProperty(AmetysObjectResolver.VIRTUAL_PROPERTY))
            {
                List<Value> values = Arrays.asList(node.getProperty(AmetysObjectResolver.VIRTUAL_PROPERTY).getValues());
                
                return values.stream()
                        .map(LambdaUtils.wrap(Value::getString))
                        .anyMatch(v -> VirtualUserDirectoryPageFactory.class.getName().equals(v));
            }
            else
            {
                return false;
            }
        }
        catch (RepositoryException e)
        {
            return false;
        }
    }
}
