/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.sitemap;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.sitemap.AbstractStaticSitemapIndicator;
import org.ametys.web.sitemap.SitemapTreeIndicator;

/**
 * {@link SitemapTreeIndicator} for orgunit root page
 */
public class OrgUnitRootSitemapIndicator extends AbstractStaticSitemapIndicator implements Serviceable
{
    /** The organisation chart page handler */
    protected OrganisationChartPageHandler _pageHandler;
    
    public void service(ServiceManager smanager) throws ServiceException
    {
        _pageHandler = (OrganisationChartPageHandler) smanager.lookup(OrganisationChartPageHandler.ROLE);
    }
    
    public boolean matches(SitemapElement sitemapElement)
    {
        if (sitemapElement instanceof Page page && page instanceof JCRAmetysObject jcrPage)
        {
            if (_pageHandler.isOrganisationChartRootPage(jcrPage))
            {
                return true;
            }
        }
        return false;
    }
}
