/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.ibatis.session.SqlSession;

import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.datasource.ConnectionHelper;

/**
 * DAO for {@link SQLSynchronizableUDOrgunitCollection}s which need to access a SQL database
 */
public class SQLUserSearchDAO extends AbstractMyBatisDAO
{
    /** Avalon ROLE */
    public static final String ROLE = SQLUserSearchDAO.class.getName();
    
    /** The datesource id */
    protected String _dataSourceId;
    
    /**
     * Get the list of synchronized content
     * @param params the filter paramaters
     * @param dataSourceId the datasource ID
     * @return the list of synchronized content
     */
    public List<Map<String, Object>> searchUser(Map<String, Object> params, String dataSourceId)
    {
        _setDataSourceId(dataSourceId);
        try (SqlSession session = getSession();
             Connection connection = session.getConnection();)
        {
            Map<String, Object> sqlParams = new HashMap<>(params);
            sqlParams.put("databaseType", ConnectionHelper.getDatabaseType(connection));
            return session.selectList("UserDirectory.search", sqlParams);
        }
        catch (SQLException e)
        {
            throw new IllegalStateException("A database access error occured, connection could not be closed.", e);
        }
    }
    
    @Override
    protected void _configureDatasource(Configuration configuration) throws ConfigurationException
    {
        //Do Nothing
    }
    
    @Override
    protected String _getDataSourceId()
    {
        return _dataSourceId;
    }
    
    /**
     * Set the datasource id
     * @param dataSourceId the datasource id
     */
    protected void _setDataSourceId(String dataSourceId)
    {
        this._dataSourceId = dataSourceId;
    }
    
}
