/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.transformation.xslt;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.userdirectory.page.OrgUnitPage;
import org.ametys.plugins.userdirectory.page.OrganisationChartPageResolver;

/**
 * Helper component to be used from XSL stylesheets.
 */
public class OrgUnitXSLTHelper extends org.ametys.web.transformation.xslt.AmetysXSLTHelper
{
    /** The resolver for organisation chart directory pages */
    protected static OrganisationChartPageResolver _organisationChartPageResolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _organisationChartPageResolver = (OrganisationChartPageResolver) manager.lookup(OrganisationChartPageResolver.ROLE);
    }
    
    
    /**
     * Gets the id of the page of the orgUnit content
     * @param contentId The orgUnit content id
     * @return the id of the page of the orgUnit content
     */
    public static String getOrgUnitPage(String contentId)
    {
        if (contentId == null)
        {
            return null;
        }
        
        Content content = _ametysObjectResolver.resolveById(contentId);
        if (content == null)
        {
            return null;
        }
        
        String currentSitemap = lang();
        String siteName = site();
            
        OrgUnitPage orgUnitPage = _organisationChartPageResolver.getOrgUnitPage(content, siteName, currentSitemap);
        if (orgUnitPage != null)
        {
            return orgUnitPage.getId();
        }
        
        return null;
    }
}
