/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.question.autofill.AbstractStaticAutoFillSource;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.userdirectory.forms.FormQuestionUDHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UDUserAutoFillSource
extends AbstractStaticAutoFillSource {
    protected Map<String, ModelItem> _defaultAutoFillItems;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected FormQuestionUDHelper _formQuestionUDHelper;
    protected FormDAO _formDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._formQuestionUDHelper = (FormQuestionUDHelper)manager.lookup(FormQuestionUDHelper.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._formDAO = (FormDAO)manager.lookup(FormDAO.ROLE);
    }

    public String getAutofillValue(FormQuestion question) {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        return (String)this._formQuestionUDHelper.getUserContentAttributeValue(question, userIdentity);
    }

    public Map<String, ModelItem> getModelItems() {
        this._defaultAutoFillItems = this._formQuestionUDHelper.getUDModelItems(List.of("string"));
        return this._defaultAutoFillItems;
    }

    public List<ViewItem> getViewElements() {
        ArrayList<ViewItem> viewElements = new ArrayList<ViewItem>();
        for (String attributeId : this._defaultAutoFillItems.keySet()) {
            ViewElement userSelect = new ViewElement();
            userSelect.setDefinition((ElementDefinition)this._defaultAutoFillItems.get(attributeId));
            viewElements.add((ViewItem)userSelect);
        }
        return viewElements;
    }

    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        String autofill;
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
        String string = autofill = user != null ? this.getAutofillValue(question) : null;
        if (StringUtils.isNotBlank((CharSequence)autofill)) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"default-value", (String)autofill);
        }
    }

    public boolean isCacheable(FormQuestion question) {
        return false;
    }
}

