/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.observation.AbstractContentObserver;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UserContentCacheObserver
extends AbstractContentObserver {
    protected UserDirectoryPageHandler _userPageHandler;
    protected UserDirectoryHelper _userDirectoryHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
        this._userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.deleting") || event.getId().equals("content.untag.live") || event.getId().equals("content.modified") || event.getId().equals("content.added") || event.getId().equals("content.validated");
    }

    public int getPriority() {
        return 5000;
    }

    @Override
    protected void _internalObserve(Event event, Page rootUsersPage, Content userContent) {
        if (this._isUserContent(userContent)) {
            if (!event.getId().equals("content.added")) {
                this._userPageHandler.clearCache(rootUsersPage);
                this._userDirectoryPageResolver.invalidateUserPageCache(userContent.getLanguage());
            }
            if (!event.getId().equals("content.untag.live") && !event.getId().equals("content.validated")) {
                this._userDirectoryHelper.invalidateUserContentCache(userContent.getLanguage());
            }
        }
    }
}

