/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.userdirectory.page.OrgUnitPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgUnitPage
extends AbstractConfigurableVirtualPage<OrgUnitPageFactory> {
    private String _title;
    private String _path;
    private Content _syncContent;

    public OrgUnitPage(Page root, VirtualPageConfiguration configuration, String scheme, OrgUnitPageFactory factory, Content syncContent, String path) {
        super(root, configuration, scheme, (AbstractConfigurableVirtualPageFactory)factory);
        this._path = path;
        this._syncContent = syncContent;
        this._title = this._syncContent.getTitle(LocaleUtils.toLocale((String)root.getSitemapName()));
    }

    public Content getContent() {
        return this._syncContent;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + (this._path != null ? this._path.split("/").length : 0);
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList<OrgUnitPage> children = new ArrayList<OrgUnitPage>();
        for (Content content : ((OrgUnitPageFactory)this._factory).getOrganisationChartPageHandler().getChildContents(this._syncContent)) {
            children.add(((OrgUnitPageFactory)this._factory).createOrgUnitPage(this._root, content, this._path + "/" + content.getName()));
        }
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        return this._root.getPathInSitemap() + "/" + this._path;
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        Content childContent = ((OrgUnitPageFactory)this._factory).getOrganisationChartPageHandler().getChildFromPath(this._syncContent, path);
        if (childContent != null) {
            OrgUnitPage page = ((OrgUnitPageFactory)this._factory).createOrgUnitPage(this._root, childContent, this._path + "/" + path);
            return (A)((Object)page);
        }
        return null;
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return !((OrgUnitPageFactory)this._factory).getOrganisationChartPageHandler().getChildContents(this._syncContent).stream().filter(c -> c.getName().equals(name)).collect(Collectors.toList()).isEmpty();
    }

    public String getId() throws AmetysRepositoryException {
        return "udorgunit://" + this._path + "?rootId=" + this._root.getId() + "&contentId=" + this._syncContent.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return this._syncContent.getName();
    }

    public Page getParent() throws AmetysRepositoryException {
        Content parentContent = ((OrgUnitPageFactory)this._factory).getOrganisationChartPageHandler().getParentContent(this._syncContent);
        if (parentContent != null) {
            return ((OrgUnitPageFactory)this._factory).createOrgUnitPage(this._root, parentContent, StringUtils.substringBeforeLast((String)this._path, (String)"/"));
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._path.contains("/")) {
            return this._root.getPath() + "/" + StringUtils.substringBeforeLast((String)this._path, (String)"/");
        }
        return this._root.getPath();
    }

    public String getPath() throws AmetysRepositoryException {
        return this._root.getPath() + "/" + this._path;
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((OrgUnitPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        throw new UnknownAmetysObjectException("There is no child for orgUnit page");
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return (Boolean)this._root.getValue("organization-chart-page-visible", (Object)true);
    }
}

