/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.service.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.frontoffice.search.instance.model.SearchContext;
import org.ametys.web.frontoffice.search.instance.model.SiteContext;
import org.ametys.web.frontoffice.search.instance.model.SitemapContext;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.ReturnableExtensionPoint;
import org.ametys.web.frontoffice.search.metamodel.ReturnableSaxer;
import org.ametys.web.frontoffice.search.metamodel.impl.PageReturnable;
import org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer;
import org.ametys.web.frontoffice.search.metamodel.impl.PrivateContentReturnable;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.ametys.web.search.query.ContentPageQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPageReturnable
extends PrivateContentReturnable {
    protected PageReturnable _pageReturnable;
    protected ContentTypesHelper _contentTypeHelper;
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected UserDirectoryPageResolver _userDirectoryPageResolver;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        ReturnableExtensionPoint returnableEP = (ReturnableExtensionPoint)manager.lookup(ReturnableExtensionPoint.ROLE);
        this._pageReturnable = (PageReturnable)returnableEP.getExtension(PageReturnable.ROLE);
        this._contentTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._userDirectoryPageResolver = (UserDirectoryPageResolver)((Object)manager.lookup(UserDirectoryPageResolver.ROLE));
    }

    protected Function<Query, Query> siteQueryJoiner() {
        return ContentPageQuery::new;
    }

    public ReturnableSaxer getSaxer(Collection<Returnable> allReturnables, AdditionalParameterValueMap additionalParameterValues) {
        return new UserSaxer(additionalParameterValues);
    }

    public class UserSaxer
    extends PageSaxer {
        protected Collection<String> _allContentTypes;

        public UserSaxer(AdditionalParameterValueMap additionalParameterValues) {
            super(UserPageReturnable.this._pageReturnable);
            this._allContentTypes = this._allContentTypeIds(additionalParameterValues);
        }

        private Collection<String> _currentServiceInstanceContentTypes(AdditionalParameterValueMap additionalParameterValues) {
            return UserPageReturnable.this.getContentTypeIds(additionalParameterValues);
        }

        private Collection<String> _allContentTypeIds(AdditionalParameterValueMap additionalParameterValues) {
            return this._currentServiceInstanceContentTypes(additionalParameterValues).stream().map(this::_selfAndDescendantContentTypes).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Set<String> _selfAndDescendantContentTypes(String cType) {
            return SetUtils.union(Collections.singleton(cType), (Set)UserPageReturnable.this._contentTypeExtensionPoint.getSubTypes(cType));
        }

        public String getIdentifier() {
            return PageSaxer.class.getName();
        }

        public boolean canSax(AmetysObject hit, Logger logger, SearchComponentArguments args) {
            return hit instanceof Content && UserPageReturnable.this._contentTypeHelper.isInstanceOf((Content)hit, "org.ametys.plugins.userdirectory.Content.user");
        }

        public void sax(ContentHandler contentHandler, AmetysObject hit, Logger logger, SearchComponentArguments args) throws SAXException {
            Content userContent = (Content)hit;
            SearchContext searchContext = this._getSearchContext(args);
            String siteName = this._getSiteName(args, searchContext);
            String sitemapName = this._getSitemapName(args, searchContext, userContent);
            UserPage userPage = this._resolveUserPage(userContent, siteName, sitemapName);
            this._saxUserPage(contentHandler, userPage, logger, args);
        }

        protected SearchContext _getSearchContext(SearchComponentArguments args) {
            Collection searchContexts = args.serviceInstance().getContexts();
            if (searchContexts.size() != 1) {
                throw new IllegalStateException("A search context is mandatory with UserReturnable in order to resolve the corresponding user pages. Multiple contexts are not allowed too.");
            }
            return (SearchContext)searchContexts.iterator().next();
        }

        protected String _getSiteName(SearchComponentArguments args, SearchContext searchContext) {
            SiteContext siteContext = searchContext.siteContext();
            switch (siteContext.getType()) {
                case CURRENT: {
                    return args.currentSite().getName();
                }
                case AMONG: {
                    List sites = (List)siteContext.getSites().get();
                    if (sites.size() == 1) {
                        return ((Site)sites.iterator().next()).getName();
                    }
                    throw new IllegalStateException("Site context must select one and only one site.");
                }
            }
            throw new IllegalStateException("Site context must select one and only one site.");
        }

        protected String _getSitemapName(SearchComponentArguments args, SearchContext searchContext, Content userContent) {
            SitemapContext sitemapContext = searchContext.sitemapContext();
            switch (sitemapContext.getType()) {
                case CURRENT_SITE: {
                    String contentLanguage = userContent.getLanguage();
                    return contentLanguage == null ? args.currentPage().getSitemapName() : contentLanguage;
                }
                case CHILD_PAGES: 
                case DIRECT_CHILD_PAGES: {
                    return args.currentPage().getSitemapName();
                }
                case CHILD_PAGES_OF: 
                case DIRECT_CHILD_PAGES_OF: {
                    List pages = (List)sitemapContext.getPages().get();
                    long nbSites = pages.stream().map(SiteAwareAmetysObject::getSite).distinct().count();
                    long nbSitemaps = pages.stream().map(SitemapElement::getSitemap).distinct().count();
                    if (nbSites != 1L || nbSitemaps != 1L) {
                        throw new IllegalStateException("Sitemap context must select one and only one sitemap.");
                    }
                    return ((Page)pages.iterator().next()).getSitemapName();
                }
            }
            throw new IllegalStateException("Sitemap context must select one and only one sitemap.");
        }

        protected UserPage _resolveUserPage(Content userContent, String siteName, String sitemapName) {
            for (String contentType : this._allContentTypes) {
                UserPage userPage = UserPageReturnable.this._userDirectoryPageResolver.getUserPage(userContent, siteName, sitemapName, contentType);
                if (userPage == null) continue;
                return userPage;
            }
            String msg = String.format("The page associated to the user content %s cannot be found in the current site and sitemap (%s / %s) for one of the content types %s", userContent, siteName, sitemapName, this._allContentTypes);
            throw new IllegalArgumentException(msg);
        }

        protected void _saxUserPage(ContentHandler contentHandler, UserPage userPage, Logger logger, SearchComponentArguments args) throws SAXException {
            super.sax(contentHandler, (AmetysObject)userPage, logger, args);
        }
    }
}

