/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select user metadata.
 */
Ext.define('Ametys.plugins.user.directory.widget.SelectUserMetadata', {
    extend: 'Ametys.cms.form.widget.SelectMetadata',
    
    /**
     * @private
     * @cfg {String|String[]} contentTypes This will be ignored.
     */
    
    initComponent: function()
    {
        this.contentTypes = ['org.ametys.plugins.userdirectory.Content.user'];
        
        this.callParent(arguments);
    },

    getStore: function()
    {
        var store = this.callParent(arguments);

        // Switch the url, so the list of content types will be child of org.ametys.plugins.userdirectory.Content.user
        store.getProxy().plugin = "user-directory";
        
        return store;
    }
    
});
