/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.userdirectory.page;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.ConfigurableVirtualZoneItem;
import org.ametys.web.repository.page.virtual.ConfigurableVirtualZoneItemFactory;
import org.ametys.web.repository.page.virtual.VirtualZoneItemConfiguration;

/**
 * {@link ZoneItem} holding a content.
 */
public class UserZoneItem extends ConfigurableVirtualZoneItem
{
    /**
     * Constructor.
     * @param page the parent {@link UserPage}.
     * @param configuration The configuration
     * @param scheme The scheme
     * @param factory The factory
     */
    public UserZoneItem(AbstractConfigurableVirtualPage page, VirtualZoneItemConfiguration configuration, String scheme, ConfigurableVirtualZoneItemFactory factory)
    {
        super(page, configuration, scheme, factory);
    }
    
    @Override
    public String getViewName() throws AmetysRepositoryException
    {
        // The view from the configuration of users virtual pages is ignored because the users can choose the view when they set the root page.
        Page rootPage = getRootPage();
        return rootPage != null ? rootPage.getValue(UserDirectoryPageHandler.USER_VIEW_NAME, "main") : "main";
    }
    
    Page getRootPage()
    {
        Page parent = _page.getParent();
        while (parent != null)
        {
            if (parent instanceof DefaultPage)
            {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }
}
