<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:exslt="http://exslt.org/common" 
    extension-element-prefixes="ametys escaper exslt">
    
    <!-- Template for legacy purpose -->
    <xsl:template name="piwik">
        <xsl:param name="keywordFields">
            <fields>
                <field name="textfield"/>
            </fields>
        </xsl:param>
        
        <xsl:call-template name="matomo">
            <xsl:with-param name="keywordFields" select="$keywordFields" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="matomo">
        <xsl:param name="keywordFields">
            <fields>
                <field name="textfield"/>
            </fields>
        </xsl:param>
        
        <xsl:variable name="piwikUrl" select="ametys:config('piwik-url')"/>
        <xsl:variable name="piwikId" select="ametys:siteParameter('piwik-id')"/>
        
    
        <!-- Do not call Piwik on back or preview -->
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($piwikId) != '' and normalize-space($piwikUrl) != ''">
			<!-- Piwik -->
			<script type="text/javascript">
			      var _paq = _paq || [];
			      
			      ametysCookieConsentListener.push(function(accept) {
                    if (accept)
                    {
                        _paq.push(["setDocumentTitle", document.domain + "/" + document.title]);
                        _paq.push(['setConsentGiven']);
	                  (function() {
	                    var u="<xsl:value-of select="$piwikUrl"/>/";
	                    _paq.push(["setTrackerUrl", u+"piwik.php"]);
	                    
	                    var searchTracking = false;
	                    <xsl:for-each select="exslt:node-set($keywordFields)/fields/field">
	                        var searchKeyword = "<xsl:value-of select="ametys:escapeJS(ametys:requestParameter(@name))"/>";
	                        if (searchKeyword != '')
	                        {
	                            // Internal search tracking on a search result page
	                            _paq.push(["trackSiteSearch", searchKeyword, false, false]);
	                            searchTracking = true;
	                        }
	                    </xsl:for-each>
	                    
	                    if (!searchTracking)
	                    {
	                        _paq.push(["trackPageView"]);
	                    }
	                    _paq.push(["enableLinkTracking"]);
	                    _paq.push(["setSiteId", "<xsl:value-of select="escaper:escapeJavaScript($piwikId)"/>"]);
	                    var d=document, g=d.createElement("script"), s=d.getElementsByTagName("script")[0]; g.type="text/javascript";
	                    g.defer=true; g.async=true; g.src=u+"piwik.js"; s.parentNode.insertBefore(g,s);
	                  })();
	                    }
	                    else
	                    {
	                        _paq.push(['forgetConsentGiven']);
	                    }
	                });
			</script>
			
			<noscript>
				<!-- Piwik Image Tracker -->
				<div><img src="{$piwikUrl}/piwik.php?idsite={escaper:escapeJavaScript($piwikId)}&amp;rec=1" style="border:0" alt="" /></div>
				<!-- End Piwik -->
			</noscript>
			<!-- // End Piwik Code -->
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="matomo-search-tracker">
        <xsl:param name="textField" />
        <xsl:param name="categoryFields" >[]</xsl:param>
        <xsl:param name="categoryLabels" >[]</xsl:param>
        
        <xsl:variable name="piwikUrl" select="ametys:config('piwik-url')"/>
        <xsl:variable name="piwikId" select="ametys:siteParameter('piwik-id')"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($piwikId) != '' and normalize-space($piwikUrl) != ''">
        let matomoAccept = false;
        ametysCookieConsentListener.push(function(accept) {matomoAccept = accept;});
        
        window._ametysSearchCBFunction = function(parameters, paginationIndex, total)
        {
            // Set timeout waiting to accept the cookies or not
            setTimeout(function() {
                if (matomoAccept &amp;&amp; paginationIndex == 1)
                {
                    var textField = "<xsl:value-of select="$textField" />";
                    var categoryFields = <xsl:value-of select="$categoryFields" />;
                    var categoryLabels = <xsl:value-of select="$categoryLabels" />;
                
                    var textValue = "[]";
                    var category = "";
                    for (var field in parameters)
                    {
                        if (field == textField)
                        {
                            textValue = parameters[field][0];
                        }
                        
                        if (categoryFields.length == 0 || categoryFields.indexOf(field) != -1)
                        {
                            if (category != "")
                            {
                                category += "|";
                            }
                        
                            var values = parameters[field];
                            var valuesAsText = "";
                            for (var val of values)
                            {
                                if (valuesAsText != "")
                                {
                                    valuesAsText += ",";
                                }
                                if (categoryLabels[field] &amp;&amp; categoryLabels[field][val])
                                {
                                    valuesAsText += categoryLabels[field][val];
                                }
                                else
                                {
                                    valuesAsText += val;
                                }
                            }
                            category += valuesAsText;
                        }
                    }
                    
                    _paq.push(['trackSiteSearch',
                        // Search keyword searched for
                        textValue,
                        // Search category selected in your search engine. If you do not need this, set to false
                        category,
                        // Number of results on the Search results page. Zero indicates a 'No Result Search Keyword'. Set to false if you don't know
                        total
                    ]);
                }
            }, 1);
        };
        </xsl:if>
	</xsl:template>

</xsl:stylesheet>
