<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:exslt="http://exslt.org/common" 
    extension-element-prefixes="ametys escaper exslt">
    
    <xsl:import href="gdpr:matomo" />
	
	<xsl:template name="matomo-search-helper">
        <xsl:param name="textField"><xsl:value-of select="/search/form/fields/criterion[@definition = 'common$wording$textfield' or @definition = 'common$titleorwording$textfield']/@name" /></xsl:param>
        <xsl:param name="categoryFields" >[<xsl:for-each select="/search/form/fields/criterion[enumeration]">"<xsl:value-of select="@name" />"<xsl:if test="position() != 0" >,</xsl:if></xsl:for-each>]</xsl:param>
        
        <script type="text/javascript">
            var labels = {};
            <xsl:for-each select="/search/form/fields/criterion[enumeration]">
                var itemLabels = {};
                <xsl:for-each select="enumeration/item">
                    itemLabels["<xsl:value-of select="ametys:escapeJS(@value)" />"] = "<xsl:value-of select="ametys:escapeJS(label)" />";
                </xsl:for-each>
                labels["<xsl:value-of select="@name" />"] = itemLabels;
            </xsl:for-each>
        
            <xsl:call-template name="matomo-search-tracker">
                <xsl:with-param name="textField" select="$textField" />
                <xsl:with-param name="categoryFields" select="$categoryFields" />
                <xsl:with-param name="categoryLabels">labels</xsl:with-param>
            </xsl:call-template>
        </script>
    </xsl:template>

</xsl:stylesheet>
