/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.webanalytics.matomo;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.apache.commons.lang.StringUtils;

import org.ametys.core.util.URIUtils;
import org.ametys.runtime.config.Config;
import org.ametys.web.analytics.AbstractWebAnalyticsProvider;
import org.ametys.web.repository.site.Site;

/**
 * The matomo analytics provider
 */
public class MatomoAnalyticsProvider extends AbstractWebAnalyticsProvider
{
    private static final Random _RNG = new Random((long) Math.random() * System.nanoTime());
    
    public String getEventImageUri(Site site, String category, String action, String label, int value, boolean usePlaceholderTokens)
    {
        String matomoUrl = Config.getInstance().getValue(MatomoDataHelper.MATOMO_URL_CONFIG);
        String siteId = site.getValue(MatomoDataHelper.MATOMO_SITE_ID_SITE_CONFIG);
        if (StringUtils.isNotBlank(matomoUrl) && StringUtils.isNotBlank(siteId))
        {
            Map<String, String> uriParameters = new HashMap<>();
            uriParameters.put("idsite", siteId);
            uriParameters.put("rec", "1");
            uriParameters.put("bots", "1");
            uriParameters.put("ca", "1");
            uriParameters.put("e_c", category);
            uriParameters.put("e_a", action);
            uriParameters.put("e_n", label);
            if (value > 0)
            {
                uriParameters.put("e_v", String.valueOf(value));
            }
            uriParameters.put("rand", usePlaceholderTokens ? RANDOM_NUMBER_TOKEN : String.valueOf(_RNG.nextInt(Integer.MAX_VALUE)));
            
            return URIUtils.encodeURI(matomoUrl + "/matomo.php", uriParameters);
        }
        
        return null;
    }
    
    public String getEventLinkCampaignParams(Site site, String campaign, String medium, String source)
    {
        StringBuilder linkCampaignParams = new StringBuilder();
        linkCampaignParams.append("mtm_campaign=");
        linkCampaignParams.append(campaign);
        linkCampaignParams.append("&mtm_medium=");
        linkCampaignParams.append(medium);
        linkCampaignParams.append("&mtm_source=");
        linkCampaignParams.append(source);
        
        return linkCampaignParams.toString();
    }
}
