/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.matomo;

import java.util.HashMap;
import java.util.Random;
import org.ametys.core.util.URIUtils;
import org.ametys.runtime.config.Config;
import org.ametys.web.analytics.AbstractWebAnalyticsProvider;
import org.ametys.web.repository.site.Site;
import org.apache.commons.lang3.StringUtils;

public class MatomoAnalyticsProvider
extends AbstractWebAnalyticsProvider {
    private static final Random _RNG = new Random((long)Math.random() * System.nanoTime());

    public String getEventImageUri(Site site, String category, String action, String label, int value, boolean usePlaceholderTokens) {
        String matomoUrl = (String)Config.getInstance().getValue("piwik-url");
        String siteId = (String)site.getValue("piwik-id");
        if (StringUtils.isNotBlank((CharSequence)matomoUrl) && StringUtils.isNotBlank((CharSequence)siteId)) {
            HashMap<String, String> uriParameters = new HashMap<String, String>();
            uriParameters.put("idsite", siteId);
            uriParameters.put("rec", "1");
            uriParameters.put("bots", "1");
            uriParameters.put("ca", "1");
            uriParameters.put("e_c", category);
            uriParameters.put("e_a", action);
            uriParameters.put("e_n", label);
            if (value > 0) {
                uriParameters.put("e_v", String.valueOf(value));
            }
            uriParameters.put("rand", usePlaceholderTokens ? "#random_number_token#" : String.valueOf(_RNG.nextInt(Integer.MAX_VALUE)));
            return URIUtils.encodeURI((String)(matomoUrl + "/matomo.php"), uriParameters);
        }
        return null;
    }

    public String getEventLinkCampaignParams(Site site, String campaign, String medium, String source) {
        StringBuilder linkCampaignParams = new StringBuilder();
        linkCampaignParams.append("mtm_campaign=");
        linkCampaignParams.append(campaign);
        linkCampaignParams.append("&mtm_medium=");
        linkCampaignParams.append(medium);
        linkCampaignParams.append("&mtm_source=");
        linkCampaignParams.append(source);
        return linkCampaignParams.toString();
    }
}

