/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.matomo;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.webanalytics.matomo.MatomoDataHelper;
import org.ametys.plugins.webanalytics.matomo.MatomoException;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetPageDataAction
extends ServiceableAction {
    protected MatomoDataHelper _matomoHelper;
    protected SiteManager _siteManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._matomoHelper = (MatomoDataHelper)((Object)smanager.lookup(MatomoDataHelper.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Number> result = new HashMap<String, Number>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String pageUrl = request.getParameter("pageUrl");
        String siteName = WebHelper.getSiteName((Request)request);
        if (StringUtils.isNotBlank((CharSequence)siteName)) {
            Site site = this._siteManager.getSite(siteName);
            result.put("nbLastDays", this._matomoHelper.getMatomoSiteNbLastDays(site));
            try {
                Integer nbVisitsFromLastDays = this._matomoHelper.getNbVisitsFromLastDays(site, pageUrl);
                Integer nbTotalVisits = this._matomoHelper.getNbTotalVisits(site, pageUrl);
                result.put("nbVisits", nbTotalVisits);
                result.put("nbVisitsFromLastDays", nbVisitsFromLastDays);
            }
            catch (MatomoException e) {
                this.getLogger().error("An error occurred getting matomo data from site '" + site.getTitle() + "' and page URL '" + pageUrl + "'", (Throwable)e);
            }
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

