/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.webanalytics.tracking;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;

import org.ametys.plugins.core.impl.schedule.StaticRunnable;
import org.ametys.runtime.config.Config;

/**
 * Runnable to send tracking information
 */
public class WebAnalyticsTrackingRunnable extends StaticRunnable
{
    /** Configuration key to know at which hour sending stats */
    public static final String SEND_STATS_HOUR_CONFIG = "send-statistics-hours";
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        
        String time = Config.getInstance().getValue(SEND_STATS_HOUR_CONFIG, true, "3:00");
        int hour = StringUtils.isNotEmpty(time) ? Integer.valueOf(StringUtils.substringBefore(time, ":")) : 3;
        int minute = StringUtils.isNotEmpty(time) ? Integer.valueOf(StringUtils.substringAfter(time, ":")) : 0;

        CronScheduleBuilder builder = CronScheduleBuilder.dailyAtHourAndMinute(hour, minute);
        CronTrigger trigger = (CronTrigger) builder.build();
        _cronExpression = trigger.getCronExpression();
    }
}
