/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.matomo;

import java.net.URI;
import java.util.HashMap;
import java.util.Random;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.webanalytics.matomo.tracking.MatomoTrackingProvider;
import org.ametys.plugins.webanalytics.matomo.tracking.MatomoTrackingProviderExtensionPoint;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.DeferredServiceable;
import org.ametys.web.analytics.AbstractWebAnalyticsProvider;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.matomo.java.tracking.MatomoTracker;
import org.matomo.java.tracking.TrackerConfiguration;

public class MatomoAnalyticsProvider
extends AbstractWebAnalyticsProvider
implements DeferredServiceable {
    private static final Random _RNG = new Random((long)Math.random() * System.nanoTime());
    protected MatomoTrackingProviderExtensionPoint _matomoTrackingEP;

    public void deferredService(ServiceManager manager) throws ServiceException {
        if (manager.hasService(MatomoTrackingProviderExtensionPoint.ROLE)) {
            this._matomoTrackingEP = (MatomoTrackingProviderExtensionPoint)((Object)manager.lookup(MatomoTrackingProviderExtensionPoint.ROLE));
        }
    }

    public String getEventImageUri(Site site, String category, String action, String label, int value, boolean usePlaceholderTokens) {
        this._checkSafeMode();
        String matomoUrl = (String)Config.getInstance().getValue("piwik-url");
        String siteId = (String)site.getValue("piwik-id");
        if (StringUtils.isNotBlank((CharSequence)matomoUrl) && StringUtils.isNotBlank((CharSequence)siteId)) {
            HashMap<String, String> uriParameters = new HashMap<String, String>();
            uriParameters.put("idsite", siteId);
            uriParameters.put("rec", "1");
            uriParameters.put("bots", "1");
            uriParameters.put("ca", "1");
            uriParameters.put("e_c", category);
            uriParameters.put("e_a", action);
            uriParameters.put("e_n", label);
            if (value > 0) {
                uriParameters.put("e_v", String.valueOf(value));
            }
            uriParameters.put("rand", usePlaceholderTokens ? "#random_number_token#" : String.valueOf(_RNG.nextInt(Integer.MAX_VALUE)));
            return URIUtils.encodeURI((String)(matomoUrl + "/matomo.php"), uriParameters);
        }
        return null;
    }

    public String getEventLinkCampaignParams(Site site, String campaign, String medium, String source) {
        this._checkSafeMode();
        StringBuilder linkCampaignParams = new StringBuilder();
        linkCampaignParams.append("mtm_campaign=");
        linkCampaignParams.append(campaign);
        linkCampaignParams.append("&mtm_medium=");
        linkCampaignParams.append(medium);
        linkCampaignParams.append("&mtm_source=");
        linkCampaignParams.append(source);
        return linkCampaignParams.toString();
    }

    public void sendTrackingInformation(Site site) throws Exception {
        String siteId;
        this._checkSafeMode();
        String matomoUrl = (String)Config.getInstance().getValue("piwik-url");
        if (StringUtils.isNotBlank((CharSequence)matomoUrl) && StringUtils.isNotBlank((CharSequence)(siteId = (String)site.getValue("piwik-id")))) {
            try {
                TrackerConfiguration configuration = TrackerConfiguration.builder().apiEndpoint(URI.create(matomoUrl + "/matomo.php")).defaultSiteId(Integer.valueOf(siteId)).build();
                try (MatomoTracker tracker = new MatomoTracker(configuration);){
                    for (String id : this._matomoTrackingEP.getExtensionsIds()) {
                        MatomoTrackingProvider trackingProvider = (MatomoTrackingProvider)this._matomoTrackingEP.getExtension(id);
                        tracker.sendBulkRequestAsync(trackingProvider.getRequests(site));
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred tracking site {} ({}) to Matomo", new Object[]{site.getName(), siteId, e});
            }
        }
    }

    private void _checkSafeMode() {
        if (this._matomoTrackingEP == null) {
            throw new IllegalStateException("MatomoTrackingProviderExtensionPoint service is not available in safe mode.");
        }
    }
}

