/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.matomo.tracking.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ReactionableObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.webanalytics.matomo.tracking.AbstractMatomoEventTrackingProvider;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class LikeMatomoTrackingProvider
extends AbstractMatomoEventTrackingProvider
implements Serviceable {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    @Override
    protected List<AbstractMatomoEventTrackingProvider.MatomoEvent> getEvents(Site site) {
        HashMap<Page, Integer> nbLikesByPage = new HashMap<Page, Integer>();
        BooleanExpression likesExpr = new BooleanExpression("likes", true);
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, site.getName());
        AndExpression expr = new AndExpression(new Expression[]{likesExpr, siteExpr});
        try (AmetysObjectIterable contents = this._resolver.query(ContentQueryHelper.getContentXPathQuery((Expression)expr));){
            for (Content content : contents) {
                if (!(content instanceof WebContent)) continue;
                WebContent webContent = (WebContent)content;
                if (!(content instanceof ReactionableObject)) continue;
                ReactionableObject reactionableContent = (ReactionableObject)content;
                Optional page = webContent.getReferencingPages().stream().findFirst();
                if (!page.isPresent()) continue;
                nbLikesByPage.compute((Page)page.get(), (k, v) -> (v == null ? 0 : v) + this._getNbLike(reactionableContent));
            }
        }
        return nbLikesByPage.keySet().stream().map(p -> new AbstractMatomoEventTrackingProvider.MatomoEvent(p.getSitemapName() + "/" + p.getPathInSitemap(), ((Integer)nbLikesByPage.get(p)).intValue())).toList();
    }

    private int _getNbLike(ReactionableObject reactionableContent) {
        return reactionableContent.getReactionUsers(ReactionableObject.ReactionType.LIKE).size();
    }
}

