/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.tracking;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.config.Config;
import org.ametys.web.WebConstants;
import org.ametys.web.analytics.WebAnalyticsHelper;
import org.ametys.web.analytics.WebAnalyticsProvider;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.quartz.JobExecutionContext;

public class WebAnalyticsTrackingSchedulable
extends AbstractStaticSchedulable {
    public static final String SEND_STATS_CONFIG = "send-statistics-enable";
    protected SiteManager _siteManager;
    protected WebAnalyticsHelper _webAnalyticsHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._webAnalyticsHelper = (WebAnalyticsHelper)manager.lookup(WebAnalyticsHelper.ROLE);
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        if (((Boolean)Config.getInstance().getValue(SEND_STATS_CONFIG, true, (Object)false)).booleanValue()) {
            Request request = ContextHelper.getRequest((Context)this._context);
            for (Site site : this._siteManager.getSites()) {
                request.setAttribute(WebConstants.REQUEST_ATTR_SITE, (Object)site);
                WebAnalyticsProvider provider = this._webAnalyticsHelper.getSelectedProvider(site);
                provider.sendTrackingInformation(site);
            }
        }
    }
}

