/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var AmetysMatomoHelper = {    
    
    /**
     * Get the page data from matomo.
     * @param {String} selector the parent selector to update page data
     * @param {String} contextPath the context path
     * @param {String} [pageUrl] Optional page absolute URL. It's window.location by default.
     * @param {Function} [callback] Optional callback function in case of success
     */
    getPageData: function(selector, contextPath, pageUrl, callback)
    {
        let url = pageUrl || window.location;
        $j.ajax({ 
            url: contextPath + "/_plugins/web-analytics/get-page-data" , 
            type: 'POST',
            dataType: 'json',
            data: {
                pageUrl: encodeURI(url)
            },
            success: function(jsonData) { 
                let parentDiv = $j(selector);
                if (parentDiv)
                {
                    parentDiv.find("[data-matomo='nb-visits']").html(jsonData.nbVisits);
                    parentDiv.find("[data-matomo='nb-visits-last-days']").html(jsonData.nbVisitsFromLastDays);
                    parentDiv.find("[data-matomo='last-days']").html(jsonData.nbLastDays);
                }
                
                if (callback)
                {
                    callback();
                }
            },
            error: function(xhr, status, error)
            {
                console.error("An error occurred getting matomo data for page '" + url + "'", error);
            }
        });
    }
}
