/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.ga;

import java.net.URISyntaxException;
import java.util.Random;
import org.ametys.core.util.URIUtils;
import org.ametys.web.analytics.AbstractWebAnalyticsProvider;
import org.ametys.web.repository.site.Site;
import org.apache.commons.lang3.StringUtils;

public class GoogleAnalyticsProvider
extends AbstractWebAnalyticsProvider {
    public static final String GA_GIF_URL = "https://www.google-analytics.com/__utm.gif";
    public static final String GA_VERSION = "5.3.8";
    public static final String DOMAIN_HASH = "109627128";
    private static final Random _RNG = new Random((long)Math.random() * System.nanoTime());

    public String getEventImageUri(Site site, String category, String action, String label, int value, boolean usePlaceholderTokens) {
        String gaWebId = (String)site.getValue("google-web-property-id");
        if (StringUtils.isNotBlank((CharSequence)gaWebId)) {
            String identifier = this._getEventIdentifier(category, action, label, value);
            return this._getEventImageUri(gaWebId, identifier, usePlaceholderTokens);
        }
        return null;
    }

    protected String _getEventIdentifier(String category, String action, String label, int value) {
        try {
            StringBuilder eventId = new StringBuilder();
            eventId.append("5(");
            eventId.append(this._encodeValue(category));
            eventId.append('*').append(this._encodeValue(action));
            eventId.append('*').append(this._encodeValue(label));
            eventId.append(')');
            if (value > 0) {
                eventId.append('(').append(value).append(')');
            }
            return eventId.toString();
        }
        catch (URISyntaxException e) {
            this.getLogger().error("An error occurred computing the event gif uri", (Throwable)e);
            return null;
        }
    }

    protected String _getEventImageUri(String gaWebId, String eventIdentifier, boolean usePlaceholderTokens) {
        long now = System.currentTimeMillis() / 1000L;
        StringBuilder cookieValue = new StringBuilder();
        cookieValue.append("__utma=").append(DOMAIN_HASH).append('.').append(usePlaceholderTokens ? "#random_number_token#" : Integer.valueOf(_RNG.nextInt(Integer.MAX_VALUE)));
        cookieValue.append('.').append(now).append('.').append(now).append('.').append(now).append(".1");
        cookieValue.append(";+__utmz=").append(DOMAIN_HASH).append('.').append(now);
        cookieValue.append(".1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none);");
        StringBuilder uri = new StringBuilder();
        uri.append(GA_GIF_URL);
        uri.append("?utmwv=").append(GA_VERSION);
        uri.append("&utmn=").append(usePlaceholderTokens ? "#random_number_token#" : Integer.valueOf(_RNG.nextInt(Integer.MAX_VALUE)));
        uri.append("&utmt=event");
        uri.append("&utme=").append(eventIdentifier);
        uri.append("&utmcs=UTF-8");
        uri.append("&utmje=1");
        uri.append("&utmhid=").append(usePlaceholderTokens ? "#random_number_token#" : Integer.valueOf(_RNG.nextInt(Integer.MAX_VALUE)));
        uri.append("&utmr=-");
        uri.append("&utmac=").append(gaWebId);
        String encodedCookie = URIUtils.encodeParameter((String)cookieValue.toString());
        uri.append("&utmcc=").append(encodedCookie);
        return uri.toString();
    }

    public String getEventLinkCampaignParams(Site site, String campaign, String medium, String source) {
        StringBuilder linkCampaignParams = new StringBuilder();
        linkCampaignParams.append("utm_campaign=");
        linkCampaignParams.append(campaign);
        linkCampaignParams.append("&utm_medium=");
        linkCampaignParams.append(medium);
        linkCampaignParams.append("&utm_source=");
        linkCampaignParams.append(source);
        return linkCampaignParams.toString();
    }

    public void sendTrackingInformation(Site site) throws Exception {
    }
}

