/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.archive;

import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.UnitaryImporter;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.data.extractor.xml.ModelAwareXMLValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.ModelLessXMLValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.webcontentio.archive.SitesArchiver;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.service.Service;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class SitemapImporter {
    final ImportReport _report = new ImportReport();
    private final SitesArchiver _siteArchiver;
    private final Site _site;
    private final Path _sitemapFolderPath;
    private final Path _sitemapFilePath;
    private final Path _zipArchivePath;
    private final Merger _merger;
    private final Logger _logger;
    private final DocumentBuilder _builder;
    private Sitemap _sitemap;
    private final UnitarySitemapImporter _unitarySitemapImporter = new UnitarySitemapImporter();

    SitemapImporter(SitesArchiver siteArchiver, Site site, Path sitemapPath, Path zipArchivePath, Merger merger, Logger logger, DocumentBuilder builder) {
        this._siteArchiver = siteArchiver;
        this._site = site;
        this._sitemapFolderPath = sitemapPath;
        this._sitemapFilePath = this._sitemapFolderPath.resolveSibling(this._sitemapFolderPath.getFileName() + ".xml");
        this._zipArchivePath = zipArchivePath;
        this._merger = merger;
        this._logger = logger;
        this._builder = builder;
    }

    void importSitemap() throws RepositoryException, IOException {
        boolean sitemapImported = this._fillSitemap();
        if (sitemapImported) {
            this._importAllPages();
        }
    }

    private boolean _fillSitemap() throws RepositoryException, IOException {
        Optional optionalSitemap = this._unitarySitemapImporter.unitaryImport(this._zipArchivePath, this._sitemapFilePath, this._merger, this._logger);
        if (optionalSitemap.isEmpty()) {
            return false;
        }
        this._sitemap = (Sitemap)optionalSitemap.get();
        this._createSitemapAcl();
        try {
            Archivers.unitarySave((Node)this._sitemap.getNode(), (Logger)this._logger);
            return true;
        }
        catch (Archivers.AmetysObjectNotImportedException e) {
            return false;
        }
    }

    private Sitemap _createChildSitemap(String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
        String sitemapName = Archivers.xpathEvalNonEmpty((String)"sitemap/@name", (org.w3c.dom.Node)propertiesXml);
        this._logger.info("Creating a Sitemap object for '{}' file (lang={})", (Object)this._sitemapFilePath, (Object)sitemapName);
        String uuid = StringUtils.substringAfter((String)id, (String)"://");
        Node sitemapNode = this._createChildSitemap(uuid, sitemapName);
        Sitemap sitemap = this._resolveSitemap(sitemapNode);
        this._setSitemapAttributes(sitemap, propertiesXml);
        Archivers.unitarySave((Node)sitemapNode, (Logger)this._logger);
        return sitemap;
    }

    private Node _createChildSitemap(String uuid, String sitemapName) throws RepositoryException {
        Sitemap srcSitemap = this._site.addSitemap(sitemapName);
        Node srcNode = srcSitemap.getNode();
        Node nodeWithDesiredUuid = Archivers.replaceNodeWithDesiredUuid((Node)srcNode, (String)uuid);
        return nodeWithDesiredUuid;
    }

    private Sitemap _resolveSitemap(Node node) {
        return this._siteArchiver._sitemapFactory.getAmetysObject(node, null);
    }

    private void _setSitemapAttributes(Sitemap sitemap, Document propertiesXml) throws TransformerException, RepositoryException {
        this._setAmetysInternalProperties((SitemapElement)sitemap, propertiesXml, "sitemap");
    }

    private void _createSitemapAcl() throws RepositoryException, IOException {
        Node node = this._sitemap.getNode();
        String zipEntryPath = "_metadata/" + StringUtils.strip((String)this._sitemapFolderPath.toString(), (String)"/") + "/" + "acl.xml";
        this._logger.debug("Trying to import ACL node for Sitemap '{}', from ACL XML file '{}', if it exists", (Object)node, (Object)zipEntryPath);
        Archivers.importAcl((Node)node, (Path)this._zipArchivePath, (Merger)this._merger, (String)zipEntryPath, (Logger)this._logger);
    }

    private void _createPageAcl(Node pageNode, Path pagePath) throws RepositoryException, IOException {
        String zipEntryPath = "_metadata/" + StringUtils.strip((String)pagePath.getParent().toString(), (String)"/") + "/" + MoreFiles.getNameWithoutExtension((Path)pagePath) + "/" + "acl.xml";
        this._logger.debug("Trying to import ACL node for Page '{}', from ACL XML file '{}', if it exists", (Object)pageNode, (Object)zipEntryPath);
        Archivers.importAcl((Node)pageNode, (Path)this._zipArchivePath, (Merger)this._merger, (String)zipEntryPath, (Logger)this._logger);
    }

    private void _importAllPages() throws IOException {
        Pair[] pageXmlFiles;
        for (Pair pagePathAndXml : pageXmlFiles = (Pair[])ZipEntryHelper.zipFileTree((Path)this._zipArchivePath, Optional.of(this._sitemapFolderPath.toString()), (p, attrs) -> attrs.isRegularFile()).map(path -> Pair.of((Object)path, (Object)this._getNullablePagePropertiesXml((Path)path))).filter(pathAndXml -> pathAndXml.getRight() != null).sorted(this._pageComparator()).toArray(Pair[]::new)) {
            Path pagePath = (Path)pagePathAndXml.getLeft();
            Document propertiesXml = (Document)pagePathAndXml.getRight();
            this._importPage(pagePath, propertiesXml);
        }
    }

    private Comparator<Pair<Path, Document>> _pageComparator() {
        Comparator<Path> firstComparator = Comparator.comparingInt(Path::getNameCount);
        Comparator<Path> secondComparator = Comparator.comparing(path -> path.getParent().toString());
        Comparator<Document> thirdComparator = Comparator.comparingInt(this::_getOrder);
        return Comparator.comparing(Pair::getLeft, firstComparator).thenComparing(Comparator.comparing(Pair::getLeft, secondComparator)).thenComparing(Comparator.comparing(Pair::getRight, thirdComparator));
    }

    private int _getOrder(Document propertiesXml) {
        try {
            return Integer.parseInt(Archivers.xpathEvalNonEmpty((String)"page/@order", (org.w3c.dom.Node)propertiesXml));
        }
        catch (NumberFormatException | TransformerException | Archivers.AmetysObjectNotImportedException e) {
            throw new LambdaUtils.LambdaException(e);
        }
    }

    private void _importPage(Path page, Document propertiesXml) throws ImportGlobalFailException {
        new UnitaryPageImporter(propertiesXml).unitaryImport(this._zipArchivePath, page, this._merger, this._logger);
    }

    private Document _getNullablePagePropertiesXml(Path page) {
        try {
            return this._getPropertiesXml(page);
        }
        catch (Exception e) {
            this._logger.error("An unexpected exception occured when trying to import page for '{}!{}'.", new Object[]{this._zipArchivePath, page, e});
            this._report.addError(new ImportReport.ImportError((Throwable)e));
            return null;
        }
    }

    private Document _getPropertiesXml(Path pageOrSitemap) {
        Document document;
        block8: {
            String zipEntryPath = pageOrSitemap.toString();
            InputStream stream = ZipEntryHelper.zipEntryFileInputStream((Path)this._zipArchivePath, (String)zipEntryPath);
            try {
                Document doc;
                document = doc = this._builder.parse(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new RuntimeException(String.format("The exported page/sitemap '%s' could not be read properly.", pageOrSitemap), e);
                }
            }
            stream.close();
        }
        return document;
    }

    private Node _createPage(Path pagePath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
        Path parentPageOrSitemap = pagePath.getParent();
        String parentRelPath = this._relativePath(parentPageOrSitemap);
        Node parentNode = this._retrieveParentSitemapElement(parentRelPath).getNode();
        String uuid = StringUtils.substringAfter((String)id, (String)"://");
        String pageName = MoreFiles.getNameWithoutExtension((Path)pagePath);
        this._logger.info("Creating a Page object for '{}' file (id={}, name={}, parent={})", new Object[]{pagePath, id, pageName, parentNode});
        Node pageNode = this._createChildPage(parentNode, uuid, pageName);
        ModifiablePage createdPage = this._resolvePage(pageNode);
        this._setPageAttributes(createdPage, propertiesXml);
        this._setTags(createdPage, propertiesXml);
        this._setTemplateParameters(createdPage, propertiesXml);
        this._setZones(createdPage, propertiesXml);
        Archivers.unitarySave((Node)pageNode, (Logger)this._logger);
        ImportReport importAttachmentReport = this._setPageAttachments(createdPage, pagePath);
        this._report.addFrom(importAttachmentReport);
        return pageNode;
    }

    private String _relativePath(Path pageOrSitemap) {
        String relPath = StringUtils.substringAfter((String)pageOrSitemap.toString(), (String)this._sitemapFolderPath.toString());
        relPath = StringUtils.strip((String)relPath, (String)"/");
        return relPath;
    }

    private DefaultTraversableAmetysObject _retrieveParentSitemapElement(String relPath) {
        return relPath.isEmpty() ? this._sitemap : (DefaultTraversableAmetysObject)this._siteArchiver._defaultPageFactory.getChild((DefaultTraversableAmetysObject)this._sitemap, relPath);
    }

    private Node _createChildPage(Node parentNode, String uuid, String pageName) throws RepositoryException {
        Node srcNode = parentNode.addNode(pageName, "ametys:defaultPage");
        Node nodeWithDesiredUuid = Archivers.replaceNodeWithDesiredUuid((Node)srcNode, (String)uuid);
        return nodeWithDesiredUuid;
    }

    private ModifiablePage _resolvePage(Node node) {
        return this._siteArchiver._defaultPageFactory.getAmetysObject(node, null);
    }

    private void _setPageAttributes(ModifiablePage page, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, TransformerException, Exception {
        String title = Archivers.xpathEvalNonEmpty((String)"page/@title", (org.w3c.dom.Node)propertiesXml);
        page.setTitle(title);
        String longTitle = Archivers.xpathEvalNonEmpty((String)"page/@long-title", (org.w3c.dom.Node)propertiesXml);
        page.setLongTitle(longTitle);
        Page.PageType type = Page.PageType.valueOf((String)Archivers.xpathEvalNonEmpty((String)"page/@type", (org.w3c.dom.Node)propertiesXml));
        page.setType(type);
        switch (type) {
            case LINK: {
                String url = Archivers.xpathEvalNonEmpty((String)"page/@url", (org.w3c.dom.Node)propertiesXml);
                Page.LinkType urlType = Page.LinkType.valueOf((String)Archivers.xpathEvalNonEmpty((String)"page/@urlType", (org.w3c.dom.Node)propertiesXml));
                page.setURL(urlType, url);
                break;
            }
            case CONTAINER: {
                String template = Archivers.xpathEvalNonEmpty((String)"page/@template", (org.w3c.dom.Node)propertiesXml);
                page.setTemplate(template);
                break;
            }
        }
        this._setAmetysInternalProperties((SitemapElement)page, propertiesXml, "page");
        Element pageAttributesElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)propertiesXml, (String)"page/attributes");
        Map values = new ModelLessXMLValuesExtractor(pageAttributesElement, (dataPath, dataType) -> Optional.empty(), (AbstractThreadSafeComponentExtensionPoint)this._siteArchiver._pageDataTypeExtensionPoint).extractValues();
        page.synchronizeValues(values);
    }

    private void _setAmetysInternalProperties(SitemapElement sitemapElement, Document propertiesXml, String rootTagName) throws TransformerException, RepositoryException {
        if (sitemapElement instanceof JCRAmetysObject) {
            Node sitemapElementNode = ((JCRAmetysObject)sitemapElement).getNode();
            String xpath = String.format("%s/internal/*", rootTagName);
            NodeList nodeList = XPathAPI.selectNodeList((org.w3c.dom.Node)propertiesXml, (String)xpath);
            Function<org.w3c.dom.Node, String> getInternalPropertyName = org.w3c.dom.Node::getNodeName;
            Function<org.w3c.dom.Node, String> getInternalPropertyValue = org.w3c.dom.Node::getTextContent;
            Map internalPropertiesToSet = IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).collect(Collectors.groupingBy(getInternalPropertyName, Collectors.mapping(getInternalPropertyValue, Collectors.toList())));
            for (Map.Entry internalProperty : internalPropertiesToSet.entrySet()) {
                String internalPropertyName = internalProperty.getKey();
                List internalPropertyValue = internalProperty.getValue();
                this._logger.debug("Adding to '{}' internal property '{}' with value '{}'", new Object[]{sitemapElement, internalPropertyName, internalPropertyValue});
                sitemapElementNode.setProperty(internalPropertyName, (String[])internalPropertyValue.toArray(String[]::new));
            }
        }
    }

    private void _setTags(ModifiablePage page, Document propertiesXml) throws TransformerException {
        String[] tags;
        NodeList nodeList = XPathAPI.selectNodeList((org.w3c.dom.Node)propertiesXml, (String)"page/tags/*");
        for (String tag : tags = (String[])IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).map(org.w3c.dom.Node::getNodeName).toArray(String[]::new)) {
            this._logger.debug("Tagging page '{}' with tag '{}'", (Object)page, (Object)tag);
            page.tag(tag);
        }
    }

    private void _setTemplateParameters(ModifiablePage page, Document propertiesXml) throws Exception {
        Element templateParamsElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)propertiesXml, (String)"page/templateParameters");
        if (templateParamsElement != null) {
            ModifiableModelAwareDataHolder templateParameters = page.getTemplateParametersHolder();
            Map values = new ModelAwareXMLValuesExtractor(templateParamsElement, templateParameters.getModel()).extractValues();
            templateParameters.synchronizeValues(values);
        }
    }

    private ImportReport _setPageAttachments(ModifiablePage page, Path pagePath) throws IOException, RepositoryException {
        if (page instanceof DefaultPage) {
            Node pageNode = ((DefaultPage)page).getNode();
            if (pageNode.hasNode("ametys-internal:attachments")) {
                pageNode.getNode("ametys-internal:attachments").remove();
            }
            String commonPrefix = "_metadata/" + StringUtils.strip((String)pagePath.getParent().toString(), (String)"/") + "/" + MoreFiles.getNameWithoutExtension((Path)pagePath) + "/" + "_attachments" + "/";
            return this._siteArchiver._resourcesArchiverHelper.importCollection(commonPrefix, pageNode, this._zipArchivePath, this._merger);
        }
        return new ImportReport();
    }

    private void _setZones(ModifiablePage page, Document propertiesXml) throws TransformerException, Archivers.AmetysObjectNotImportedException, Exception {
        NodeList zoneNodeList = XPathAPI.selectNodeList((org.w3c.dom.Node)propertiesXml, (String)"page/pageContents/zone");
        for (int i = 0; i < zoneNodeList.getLength(); ++i) {
            org.w3c.dom.Node zoneNode = zoneNodeList.item(i);
            this._setZone(page, zoneNode);
        }
    }

    private void _setZone(ModifiablePage page, org.w3c.dom.Node zoneNode) throws TransformerException, Archivers.AmetysObjectNotImportedException, Exception {
        String zoneName = Archivers.xpathEvalNonEmpty((String)"@name", (org.w3c.dom.Node)zoneNode);
        ModifiableZone zone = page.createZone(zoneName);
        Element zoneAttributesElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneNode, (String)"attributes");
        Map values = new ModelLessXMLValuesExtractor(zoneAttributesElement, (dataPath, dataType) -> Optional.empty(), (AbstractThreadSafeComponentExtensionPoint)this._siteArchiver._pageDataTypeExtensionPoint).extractValues();
        zone.synchronizeValues(values);
        this._setZoneParameters(zone, zoneNode);
        NodeList zoneItemNodeList = XPathAPI.selectNodeList((org.w3c.dom.Node)zoneNode, (String)"zoneItem");
        for (int i = 0; i < zoneItemNodeList.getLength(); ++i) {
            org.w3c.dom.Node zoneItemNode = zoneItemNodeList.item(i);
            this._setZoneItem(zone, zoneItemNode);
        }
    }

    private void _setZoneParameters(ModifiableZone zone, org.w3c.dom.Node zoneItemNode) throws TransformerException, Exception {
        Element zoneParamsElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneItemNode, (String)"zoneParameters");
        if (zoneParamsElement != null) {
            ModifiableModelAwareDataHolder zoneParameters = zone.getZoneParametersHolder();
            Map values = new ModelAwareXMLValuesExtractor(zoneParamsElement, zoneParameters.getModel()).extractValues();
            zoneParameters.synchronizeValues(values);
        }
    }

    private void _setZoneItem(ModifiableZone zone, org.w3c.dom.Node zoneItemNode) throws TransformerException, Exception {
        ModifiableZoneItem zoneItem = zone.addZoneItem();
        ZoneItem.ZoneType zoneType = ZoneItem.ZoneType.valueOf((String)Archivers.xpathEvalNonEmpty((String)"@type", (org.w3c.dom.Node)zoneItemNode));
        zoneItem.setType(zoneType);
        this._setZoneItemAttributes(zoneItem, zoneItemNode);
        this._setZoneItemParameters(zoneItem, zoneItemNode);
        switch (zoneType) {
            case CONTENT: {
                this._setZoneItemContent(zoneItem, zoneItemNode);
                this._setZoneItemContentViewParameters(zoneItem, zoneItemNode);
                break;
            }
            case SERVICE: {
                String serviceId = Archivers.xpathEvalNonEmpty((String)"@serviceId", (org.w3c.dom.Node)zoneItemNode);
                zoneItem.setServiceId(serviceId);
                this._setZoneItemServiceParams(zoneItem, zoneItemNode, serviceId);
                this._setZoneItemServiceViewParameters(zoneItem, zoneItemNode, serviceId);
                break;
            }
        }
    }

    private void _setZoneItemAttributes(ModifiableZoneItem zoneItem, org.w3c.dom.Node zoneItemNode) throws TransformerException, Exception {
        Element zoneItemAttributesElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneItemNode, (String)"attributes");
        Map values = new ModelLessXMLValuesExtractor(zoneItemAttributesElement, (dataPath, type) -> Optional.empty(), (AbstractThreadSafeComponentExtensionPoint)this._siteArchiver._pageDataTypeExtensionPoint).extractValues();
        zoneItem.synchronizeValues(values);
    }

    private void _setZoneItemParameters(ModifiableZoneItem zoneItem, org.w3c.dom.Node zoneItemNode) throws TransformerException, Exception {
        Element zoneItemParamsElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneItemNode, (String)"zoneItemParameters");
        if (zoneItemParamsElement != null) {
            ModifiableModelAwareDataHolder zoneItemParameters = zoneItem.getZoneItemParametersHolder();
            Map values = new ModelAwareXMLValuesExtractor(zoneItemParamsElement, zoneItemParameters.getModel()).extractValues();
            zoneItemParameters.synchronizeValues(values);
        }
    }

    private void _setZoneItemContent(ModifiableZoneItem zoneItem, org.w3c.dom.Node zoneItemNode) throws TransformerException, Archivers.AmetysObjectNotImportedException {
        XObject viewNameXObject;
        String contentId = Archivers.xpathEvalNonEmpty((String)"@contentId", (org.w3c.dom.Node)zoneItemNode);
        if (this._siteArchiver._resolver.hasAmetysObjectForId(contentId)) {
            Content content = (Content)this._siteArchiver._resolver.resolveById(contentId);
            zoneItem.setContent(content);
        }
        if ((viewNameXObject = XPathAPI.eval((org.w3c.dom.Node)zoneItemNode, (String)"@viewName")).getType() != -1) {
            String viewName = viewNameXObject.str();
            zoneItem.setViewName(viewName);
        }
    }

    private void _setZoneItemContentViewParameters(ModifiableZoneItem zoneItem, org.w3c.dom.Node zoneItemNode) throws TransformerException, Exception {
        Element contentViewParamsElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneItemNode, (String)"contentViewParameters");
        if (contentViewParamsElement != null) {
            String viewName = (String)StringUtils.defaultIfBlank((CharSequence)zoneItem.getViewName(), (CharSequence)"main");
            ModifiableModelAwareDataHolder contentViewParameters = zoneItem.getContentViewParametersHolder(viewName);
            Map values = new ModelAwareXMLValuesExtractor(contentViewParamsElement, contentViewParameters.getModel()).extractValues();
            contentViewParameters.synchronizeValues(values);
        }
    }

    private void _setZoneItemServiceParams(ModifiableZoneItem zoneItem, org.w3c.dom.Node zoneItemNode, String serviceId) throws Exception {
        Element serviceParamsElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneItemNode, (String)"serviceParameters");
        Service service = this._getService(serviceId);
        if (service == null) {
            String message = String.format("Service with id '%s' for ZoneItem \"%s\" does not exist", serviceId, zoneItem);
            this._logger.error(message);
            this._report.addError(new ImportReport.ImportError((Throwable)new Exception(message)));
        } else {
            XMLValuesExtractorAdditionalDataGetter additionalDataGetter = (dataPath, type) -> Optional.empty();
            View view = View.of((Model)service);
            Map values = new ModelAwareXMLValuesExtractor(serviceParamsElement, additionalDataGetter, new Model[]{service}).extractValues(view);
            ModifiableModelAwareDataHolder serviceParametersDataHolder = zoneItem.getServiceParameters();
            serviceParametersDataHolder.synchronizeValues((ViewItemAccessor)view, values);
        }
    }

    private void _setZoneItemServiceViewParameters(ModifiableZoneItem zoneItem, org.w3c.dom.Node zoneItemNode, String serviceId) throws TransformerException, Exception {
        Element serviceViewParamsElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)zoneItemNode, (String)"serviceViewParameters");
        Service service = this._getService(serviceId);
        if (service != null && serviceViewParamsElement != null) {
            ModifiableModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
            if (serviceParameters.hasDefinition("xslt")) {
                String viewName = (String)serviceParameters.getValue("xslt");
                ModifiableModelAwareDataHolder serviceViewParameters = zoneItem.getServiceViewParametersHolder(viewName);
                Map values = new ModelAwareXMLValuesExtractor(serviceViewParamsElement, serviceViewParameters.getModel()).extractValues();
                serviceViewParameters.synchronizeValues(values);
            } else {
                String message = String.format("Service with id '%s' for ZoneItem \"%s\" doesn't have view but has view parameters.", zoneItem.getServiceId(), zoneItem);
                this._logger.error(message);
                this._report.addError(new ImportReport.ImportError((Throwable)new Exception(message)));
            }
        }
    }

    private Service _getService(String serviceId) {
        return (Service)this._siteArchiver._serviceExtensionPoint.getExtension(serviceId);
    }

    private final class UnitarySitemapImporter
    implements UnitaryImporter<Sitemap> {
        private UnitarySitemapImporter() {
        }

        public String objectNameForLogs() {
            return "Sitemap";
        }

        public Document getPropertiesXml(Path zipEntryPath) throws Exception {
            return SitemapImporter.this._getPropertiesXml(zipEntryPath);
        }

        public String retrieveId(Document propertiesXml) throws Exception {
            return Archivers.xpathEvalNonEmpty((String)"sitemap/@id", (org.w3c.dom.Node)propertiesXml);
        }

        public Sitemap create(Path zipEntryPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, ImportGlobalFailException, Exception {
            return SitemapImporter.this._createChildSitemap(id, propertiesXml);
        }

        public ImportReport getReport() {
            return SitemapImporter.this._report;
        }
    }

    private class UnitaryPageImporter
    implements UnitaryImporter<Node> {
        private Document _propertiesXml;

        UnitaryPageImporter(Document propertiesXml) {
            this._propertiesXml = propertiesXml;
        }

        public String objectNameForLogs() {
            return "Page";
        }

        public Document getPropertiesXml(Path zipEntryPath) throws Exception {
            return this._propertiesXml;
        }

        public String retrieveId(Document propertiesXml) throws Exception {
            return Archivers.xpathEvalNonEmpty((String)"page/@id", (org.w3c.dom.Node)propertiesXml);
        }

        public Node create(Path zipEntryPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
            Node pageNode = SitemapImporter.this._createPage(zipEntryPath, id, propertiesXml);
            SitemapImporter.this._createPageAcl(pageNode, zipEntryPath);
            Archivers.unitarySave((Node)pageNode, (Logger)SitemapImporter.this._logger);
            return pageNode;
        }

        public ImportReport getReport() {
            return SitemapImporter.this._report;
        }
    }
}

