/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.archive;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.ametys.plugins.contentio.archive.DefaultPluginArchiver;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.ResourcesArchiverHelper;
import org.ametys.plugins.contentio.archive.SystemViewHandler;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.ContentHandler;

public class WebExplorerArchiver
extends DefaultPluginArchiver {
    private static final String __WEB_EXPLORER_NODE_NAME = "web-explorer";
    private static final String __SHARED_RESOURCES_NODE_NAME = "shared-resources";
    private AmetysObjectResolver _resolver;
    private ResourcesArchiverHelper _resourcesArchiverHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._resourcesArchiverHelper = (ResourcesArchiverHelper)manager.lookup(ResourcesArchiverHelper.ROLE);
    }

    public void export(String pluginName, Node node, ZipOutputStream zos, String prefix) throws IOException {
        super.export(pluginName, node, zos, prefix);
        try {
            if (node.hasNode(__SHARED_RESOURCES_NODE_NAME)) {
                Node sharedResourcesNode = node.getNode(__SHARED_RESOURCES_NODE_NAME);
                NodeIterator it = sharedResourcesNode.getNodes();
                while (it.hasNext()) {
                    Node resources = it.nextNode();
                    ResourceCollection rootResources = (ResourceCollection)this._resolver.resolve(resources, false);
                    this._resourcesArchiverHelper.exportCollection(rootResources, zos, prefix + "/shared-resources/" + resources.getName() + "/");
                }
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to archive plugin " + pluginName, e);
        }
    }

    protected ContentHandler getSystemViewHandler(ContentHandler initialHandler) {
        return new SystemViewHandler(initialHandler, name -> List.of("ametys:contents", __SHARED_RESOURCES_NODE_NAME).contains(name), __ -> false);
    }

    public ImportReport partialImport(String pluginName, Node allPluginsNode, Path zipPath, String zipPluginEntryPath, Merger merger) throws IOException {
        this._removeWebExplorerNode(allPluginsNode);
        ImportReport importPluginReport = super.partialImport(pluginName, allPluginsNode, zipPath, zipPluginEntryPath, merger);
        Node webExplorerNode = this._getWebExplorerNode(allPluginsNode);
        ImportReport importResourceReport = new ImportReport();
        String zipSharedResourcesEntryPath = zipPluginEntryPath + "/shared-resources/";
        if (ZipEntryHelper.zipEntryFolderExists((Path)zipPath, (String)zipSharedResourcesEntryPath)) {
            importResourceReport = this._importSharedResources(webExplorerNode, zipPath, zipSharedResourcesEntryPath, merger);
        }
        return ImportReport.union((ImportReport[])new ImportReport[]{importPluginReport, importResourceReport});
    }

    private void _removeWebExplorerNode(Node allPluginsNode) throws IOException {
        try {
            if (allPluginsNode.hasNode(__WEB_EXPLORER_NODE_NAME)) {
                allPluginsNode.getNode(__WEB_EXPLORER_NODE_NAME).remove();
                allPluginsNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    private Node _getWebExplorerNode(Node allPluginsNode) throws IOException {
        try {
            Node webExplorerNode = allPluginsNode.getNode(__WEB_EXPLORER_NODE_NAME);
            return webExplorerNode;
        }
        catch (RepositoryException e) {
            throw new IOException("Unexpected state. The 'web-explorer' node was not imported.", e);
        }
    }

    private ImportReport _importSharedResources(Node webExplorerNode, Path zipPath, String zipSharedResourcesEntryPath, Merger merger) throws IOException {
        DirectoryStream roots;
        Node sharedResourcesNode;
        ArrayList<ImportReport> reports = new ArrayList<ImportReport>();
        try {
            sharedResourcesNode = webExplorerNode.hasNode(__SHARED_RESOURCES_NODE_NAME) ? webExplorerNode.getNode(__SHARED_RESOURCES_NODE_NAME) : webExplorerNode.addNode(__SHARED_RESOURCES_NODE_NAME, "ametys:unstructured");
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
        try (DirectoryStream directoryStream = roots = ZipEntryHelper.children((Path)zipPath, Optional.of(zipSharedResourcesEntryPath), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path rootPath : roots) {
                Node parentOfRootResources = sharedResourcesNode;
                ImportReport importCollectionReport = this._resourcesArchiverHelper.importCollection(rootPath.toString() + "/", parentOfRootResources, zipPath, merger);
                reports.add(importCollectionReport);
            }
        }
        return ImportReport.union(reports);
    }
}

