/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio;

import com.opensymphony.workflow.WorkflowException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightsException;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.webcontentio.ContentImporter;
import org.ametys.plugins.webcontentio.ContentImporterExtensionPoint;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.web.repository.content.ModifiableWebContent;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.FileUtils;
import org.apache.excalibur.source.SourceUtil;

public class ContentIOManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ContentIOManager.class.getName();
    private Context _context;
    private ContentImporterExtensionPoint _contentImporterExtensionPoint;
    private ContentTypeExtensionPoint _contentTypeExtensionPoint;
    private RightManager _rightsManager;
    private WorkflowProvider _workflowProvider;
    private CurrentUserProvider _currentUserProvider;
    private AmetysObjectResolver _resolver;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._contentImporterExtensionPoint = (ContentImporterExtensionPoint)((Object)manager.lookup(ContentImporterExtensionPoint.ROLE));
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._rightsManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable
    public Map<String, Object> importContent(String directoryPath, String rootPageId) throws ProcessingException, AmetysRepositoryException {
        UserIdentity user = this._currentUserProvider.getUser();
        SitemapElement rootPage = (SitemapElement)this._resolver.resolveById(rootPageId);
        if (!(rootPage instanceof ModifiableAmetysObject)) {
            throw new ProcessingException("The selected page '" + rootPage.getPath() + "' is not modifiable.");
        }
        int[] result = this.importContent(directoryPath, rootPage, user);
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        mapResult.put("success", result[0]);
        mapResult.put("error", result[1]);
        return mapResult;
    }

    public int[] importContent(String path, SitemapElement rootPage, UserIdentity user) throws ProcessingException {
        int[] result = new int[2];
        File file = new File(path);
        if (!file.exists()) {
            throw new ProcessingException("The file '" + path + "' does not exist.");
        }
        if (file.isFile()) {
            ModifiablePage page = this._importFromFile(file, rootPage, user, false);
            if (page != null) {
                result[0] = result[0] + 1;
            } else {
                result[1] = result[1] + 1;
            }
        } else {
            result = this._importFromDirectory(file, rootPage, user, false);
        }
        if (rootPage.getSite().needsSave()) {
            rootPage.getSite().saveChanges();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModifiablePage importContent(InputStream is, String mimeType, String contentName, UserIdentity user, SitemapElement rootPage, boolean isContextExtern) throws IOException {
        ModifiablePage modifiablePage;
        File tmpFile = null;
        try {
            tmpFile = new File(System.getProperty("java.io.tmpdir") + File.separator + Long.toString(Math.round(Math.random() * 1000000.0)), contentName);
            tmpFile.getParentFile().mkdirs();
            tmpFile.createNewFile();
            try (FileOutputStream tmpFileOS = new FileOutputStream(tmpFile);){
                SourceUtil.copy((InputStream)is, (OutputStream)tmpFileOS);
            }
            ModifiablePage page = this._importFromFile(tmpFile, rootPage, user, isContextExtern);
            if (rootPage.getSite().needsSave()) {
                rootPage.getSite().saveChanges();
            }
            modifiablePage = page;
        }
        catch (FileNotFoundException e) {
            try {
                this.getLogger().warn("Unable to create a temporary file " + tmpFile.getAbsolutePath() + " to import.");
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tmpFile);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)tmpFile);
            return null;
        }
        FileUtils.deleteQuietly((File)tmpFile);
        return modifiablePage;
    }

    private int[] _importFromDirectory(File dir, SitemapElement rootPage, UserIdentity user, boolean isContextExtern) {
        File[] children;
        int[] result = new int[2];
        for (File child : children = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return !name.startsWith(directory.getName() + ".");
            }
        })) {
            if (child.isFile()) {
                ModifiablePage page = this._importFromFile(child, rootPage, user, isContextExtern);
                if (page != null) {
                    result[0] = result[0] + 1;
                    continue;
                }
                result[1] = result[1] + 1;
                continue;
            }
            if (!child.isDirectory()) continue;
            File[] subChildren = child.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String name) {
                    return name.startsWith(directory.getName() + ".");
                }
            });
            boolean contentImported = false;
            ModifiablePage childPage = null;
            if (subChildren.length > 0) {
                childPage = this._importFromFile(subChildren[0], rootPage, user, isContextExtern);
                if (childPage != null) {
                    result[0] = result[0] + 1;
                } else {
                    result[1] = result[1] + 1;
                }
                boolean bl = contentImported = childPage != null;
            }
            if (!contentImported) {
                String pageTitle = child.getName();
                String originalPageName = NameHelper.filterName((String)pageTitle);
                Object pageName = originalPageName;
                int index = 2;
                while (rootPage.hasChild((String)pageName)) {
                    pageName = originalPageName + "-" + index++;
                }
                childPage = (ModifiablePage)((ModifiableTraversableAmetysObject)rootPage).createChild((String)pageName, "ametys:defaultPage");
                childPage.setType(Page.PageType.NODE);
                childPage.setSiteName(rootPage.getSiteName());
                childPage.setSitemapName(rootPage.getSitemapName());
                childPage.setTitle(child.getName());
            }
            int[] subResult = this._importFromDirectory(child, (SitemapElement)childPage, user, isContextExtern);
            result[0] = result[0] + subResult[0];
            result[1] = result[1] + subResult[1];
        }
        return result;
    }

    private ModifiablePage _importFromFile(File file, SitemapElement rootPage, UserIdentity user, boolean isContextExtern) {
        String mimeType = this._context.getMimeType(file.getName());
        ContentImporter importer = this._contentImporterExtensionPoint.getContentImporterForMimeType(mimeType);
        if (importer == null) {
            this.getLogger().warn("Unable to import file " + file.getAbsolutePath() + ": no importer found.");
            return null;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            Content content = this._convertFileToContent(importer, file, rootPage.getSite(), rootPage.getSitemap(), user, params);
            if (content != null) {
                if (!this.hasRight(content.getTypes()[0], rootPage, user, isContextExtern)) {
                    throw new RightsException("insufficient rights to create a new page and content for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'.");
                }
                ModifiablePage page = this._createPageAndSetContent(rootPage, content, rootPage.getSite(), rootPage.getSitemap(), params, file);
                importer.postTreatment(page, content, file);
                return page;
            }
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().error("Unable to import content from file " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to import content from file " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (WorkflowException e) {
            this.getLogger().error("Unable to import content from file " + file.getAbsolutePath(), (Throwable)e);
        }
        return null;
    }

    private Content _convertFileToContent(ContentImporter importer, File file, Site site, Sitemap sitemap, UserIdentity user, Map<String, String> params) throws WorkflowException, AmetysRepositoryException {
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
        long workflowId = workflow.initialize("content", 0, new HashMap());
        ModifiableTraversableAmetysObject rootContents = site.getRootContents();
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        String desiredContentName = i != -1 ? fileName.substring(0, i) : fileName;
        String originalContentName = NameHelper.filterName((String)desiredContentName);
        Object contentName = originalContentName;
        int index = 2;
        while (rootContents.hasChild((String)contentName)) {
            contentName = originalContentName + "-" + index++;
        }
        ModifiableWebContent content = (ModifiableWebContent)rootContents.createChild((String)contentName, "ametys:defaultWebContent");
        ((WorkflowAwareContent)content).setWorkflowId(workflowId);
        content.setCreator(user);
        content.setCreationDate(ZonedDateTime.now());
        content.setLastContributor(user);
        content.setLastModified(ZonedDateTime.now());
        content.setLanguage(sitemap.getName());
        content.setSiteName(site.getName());
        try {
            importer.importContent(file, content, params);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to import content from file " + file.getAbsolutePath(), (Throwable)e);
            content.remove();
            return null;
        }
        return content;
    }

    private ModifiablePage _createPageAndSetContent(SitemapElement rootPage, Content content, Site site, Sitemap sitemap, Map<String, String> params, File file) {
        String template = params.get("page.template");
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        String pageTitle = i != -1 ? fileName.substring(0, i) : fileName;
        String originalPageName = NameHelper.filterName((String)pageTitle);
        Object pageName = originalPageName;
        int index = 2;
        while (rootPage.hasChild((String)pageName)) {
            pageName = originalPageName + "-" + index++;
        }
        ModifiablePage page = (ModifiablePage)((ModifiableTraversableAmetysObject)rootPage).createChild((String)pageName, "ametys:defaultPage");
        page.setType(Page.PageType.CONTAINER);
        page.setTemplate(template == null ? "page" : template);
        page.setSiteName(site.getName());
        page.setSitemapName(sitemap.getName());
        page.setTitle(pageTitle);
        String longTitle = params.get("page.longTitle");
        if (longTitle != null) {
            page.setLongTitle(longTitle);
        }
        ModifiableZone zone = page.createZone("default");
        ModifiableZoneItem zoneItem = zone.addZoneItem();
        zoneItem.setType(ZoneItem.ZoneType.CONTENT);
        zoneItem.setContent(content);
        return page;
    }

    protected boolean hasRight(String contentTypeId, SitemapElement page, UserIdentity user, boolean isContextExtern) {
        ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension(contentTypeId);
        if (contentType != null) {
            String right = contentType.getRight();
            return right == null || this._rightsManager.hasRight(user, right, (Object)page) == RightManager.RightResult.RIGHT_ALLOW;
        }
        return false;
    }
}

