/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.webcontentio.ContentIOManager;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang.StringUtils;

public class ImportContentAction
extends ServiceableAction
implements Contextualizable {
    private AuthenticationTokenManager _authenticationManager;
    private ContentIOManager _contentIOManager;
    private SiteManager _siteManager;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._authenticationManager = (AuthenticationTokenManager)this.manager.lookup(AuthenticationTokenManager.ROLE);
        this._contentIOManager = (ContentIOManager)((Object)this.manager.lookup(ContentIOManager.ROLE));
        this._siteManager = (SiteManager)this.manager.lookup(SiteManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        UserIdentity user;
        String authenticationToken;
        Object content;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        ArrayList<String> error = new ArrayList<String>();
        Boolean success = true;
        if (!"POST".equals(request.getMethod())) {
            success = false;
            error.add("Only POST methods are allowed.");
            this.getLogger().warn("Only POST methods are allowed.");
        }
        if ((content = request.get("content")) == null) {
            success = false;
            error.add("No content provided. The parameter 'content' is mandatory.");
            this.getLogger().warn("No content provided. The parameter 'content' is mandatory.");
        }
        if ((authenticationToken = (String)request.get("key")) == null) {
            success = false;
            error.add("No API key provided. The parameter 'key' is mandatory.");
            this.getLogger().warn("No API key provided. The parameter 'key' is mandatory.");
        }
        if ((user = this._authenticationManager.validateToken(authenticationToken)) == null) {
            success = false;
            error.add("The API key provided is invalid, please check the value of the parameter 'key'.");
            this.getLogger().warn("The API key provided is invalid, please check the value of the parameter 'key'.");
        }
        String siteName = parameters.getParameter("site");
        String sitemapName = parameters.getParameter("sitemap");
        String path = parameters.getParameter("path");
        boolean extern = parameters.getParameterAsBoolean("extern", false);
        SitemapElement rootPage = this.getPageFromPath(siteName, sitemapName, path);
        if (rootPage == null) {
            success = false;
            error.add("Unable to retrieve the parent page, the specified path was not found.");
            this.getLogger().warn("Unable to retrieve the parent page, the specified path was not found.");
        }
        if (success.booleanValue() && content instanceof Part) {
            Part part = (Part)content;
            InputStream is = part.getInputStream();
            String contentName = part.getUploadName();
            String mimeType = this._context.getMimeType(contentName);
            try {
                this._contentIOManager.importContent(is, mimeType, contentName, user, rootPage, extern);
            }
            catch (RightsException e) {
                success = false;
                error.add("Insufficient rights to create a content.");
                this.getLogger().warn("Insufficient rights to create a content.");
            }
        }
        HashMap<String, Serializable> mapResult = new HashMap<String, Serializable>();
        mapResult.put("success", success);
        if (!success.booleanValue()) {
            mapResult.put("error", error);
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, mapResult);
        return EMPTY_MAP;
    }

    private SitemapElement getPageFromPath(String siteName, String sitemapName, String path) {
        Site site = null;
        Sitemap sitemap = null;
        try {
            site = this._siteManager.getSite(siteName);
            sitemap = site.getSitemap(sitemapName);
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().warn("Unable to retrieve the site or sitemap.", (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((String)path) || "/".equals(path)) {
            return sitemap;
        }
        String pathCleaned = path;
        if (pathCleaned.startsWith("/")) {
            pathCleaned = pathCleaned.substring(1);
        }
        if (pathCleaned.endsWith("/")) {
            pathCleaned = pathCleaned.substring(0, path.length() - 1);
        }
        String[] pagesName = pathCleaned.split("/");
        Sitemap page = sitemap;
        for (int i = 0; i < pagesName.length; ++i) {
            if (StringUtils.isEmpty((String)pagesName[i])) {
                return null;
            }
            if ((page = (SitemapElement)page.getChild(pagesName[i])) != null) continue;
            return null;
        }
        return page;
    }
}

