/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.docx;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.cms.data.NamedResource;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocxImagesTransformer
extends AbstractTransformer
implements Contextualizable {
    private ZipFile _zipFile;
    private Content _content;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        Map parentContext = (Map)objectModel.get("parent-context");
        this._zipFile = (ZipFile)parentContext.get("zipFile");
        this._content = (Content)parentContext.get("content");
    }

    public void startElement(String uri, String localName, String raw, Attributes atts) throws SAXException {
        if ("imagedata".equals(localName) && "local".equals(atts.getValue("type"))) {
            String fileName = atts.getValue("filename");
            String fileRef = atts.getValue("fileref");
            AttributesImpl atts2 = new AttributesImpl();
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                if ("filename".equals(name) || "fileref".equals(name)) continue;
                atts2.addAttribute(atts.getURI(i), atts.getLocalName(i), name, atts.getType(i), atts.getValue(i));
            }
            atts2.addAttribute("", "fileref", "fileref", "CDATA", fileName);
            ZipArchiveEntry entry = this._zipFile.getEntry("word/" + fileRef);
            try (InputStream is = this._zipFile.getInputStream(entry);){
                NamedResource file = new NamedResource();
                file.setLastModificationDate(ZonedDateTime.now());
                file.setInputStream(is);
                String mimeType = this._context.getMimeType(fileName);
                file.setMimeType(mimeType != null ? mimeType : "application/unknown");
                RichText richText = (RichText)this._content.getValue("content");
                if (richText == null) {
                    richText = new RichText();
                }
                richText.addAttachment(file);
                ((ModifiableContent)this._content).setValue("content", (Object)richText);
            }
            catch (IOException e) {
                throw new SAXException("Unable to get image in the docx file", e);
            }
            super.startElement(uri, localName, raw, (Attributes)atts2);
            return;
        }
        super.startElement(uri, localName, raw, atts);
    }

    public void recycle() {
        super.recycle();
        this._zipFile = null;
        this._content = null;
    }
}

