/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.Geocode;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.plugins.webcontentio.ContentImporter;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.web.repository.content.ModifiableWebContent;
import org.ametys.web.repository.page.ModifiablePage;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlContentImporter
extends AbstractLogEnabled
implements ContentImporter,
Serviceable {
    private DOMParser _domParser;
    private XPathProcessor _xPathProcessor;
    private ContentTypeExtensionPoint _contentTypeExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._domParser = (DOMParser)manager.lookup(DOMParser.ROLE);
        this._xPathProcessor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    @Override
    public void importContent(File file, ModifiableWebContent content, Map<String, String> params) throws IOException {
        Document doc = this.getXmlDocFromFile(file);
        if (doc == null) {
            throw new IOException("Unable to retrieve the xml document from the file received.");
        }
        Node xmlContent = this._xPathProcessor.selectSingleNode((Node)doc, "/content");
        String contentTypeId = this._xPathProcessor.evaluateAsString(xmlContent, "@type");
        if (StringUtils.isEmpty((CharSequence)contentTypeId)) {
            throw new IOException("Invalid file content : no content type specified.");
        }
        if (!this._contentTypeExtensionPoint.hasExtension(contentTypeId)) {
            throw new IOException("Invalid file content : the specified content type does not exist.");
        }
        content.setTypes(new String[]{contentTypeId});
        Node title = this._xPathProcessor.selectSingleNode(xmlContent, "title");
        if (title == null) {
            throw new IOException("Invalid file content : no title found, but it is mandatory.");
        }
        this._importAttributes(content, xmlContent);
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/xml", "text/xml"};
    }

    @Override
    public void postTreatment(ModifiablePage page, Content content, File file) throws IOException {
    }

    private Document getXmlDocFromFile(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        Document doc = null;
        try {
            doc = this._domParser.parseDocument(new InputSource(reader));
        }
        catch (SAXException e) {
            this.getLogger().error("[IMPORT] Unable to parse imported file " + file.getName(), (Throwable)e);
        }
        return doc;
    }

    private void _importAttributes(ModifiableWebContent content, Node xmlContent) throws IOException {
        NodeList attributesNodes = xmlContent.getChildNodes();
        for (int i = 0; i < attributesNodes.getLength(); ++i) {
            Node attributeNode = attributesNodes.item(i);
            if (attributeNode.getNodeType() != 1 || !content.hasDefinition(attributeNode.getLocalName())) continue;
            ModelItem attributeDefinition = content.getDefinition(attributeNode.getLocalName());
            this._importAttribute((ModifiableModelAwareDataHolder)content, attributeDefinition, attributeNode);
        }
    }

    private void _importAttribute(ModifiableModelAwareDataHolder dataHolder, ModelItem attributeDefinition, Node attributeNode) throws IOException {
        if (attributeDefinition != null) {
            if (attributeDefinition instanceof RepeaterDefinition) {
                this._setRepeater(dataHolder, (RepeaterDefinition)attributeDefinition, attributeNode);
            } else if (attributeDefinition instanceof CompositeDefinition) {
                this._setComposite(dataHolder, (CompositeDefinition)attributeDefinition, attributeNode);
            } else if (attributeDefinition instanceof ElementDefinition) {
                this._setAttribute(dataHolder, (ElementDefinition)attributeDefinition, attributeNode);
            }
        }
    }

    private void _setRepeater(ModifiableModelAwareDataHolder dataHolder, RepeaterDefinition repeaterDefinition, Node repeaterNode) throws IOException {
        NodeList entryNodes = this._xPathProcessor.selectNodeList(repeaterNode, "entry");
        if (entryNodes.getLength() > 0) {
            ModifiableModelAwareRepeater repeaterData = dataHolder.getRepeater(repeaterDefinition.getName(), true);
            for (int i = 0; i < entryNodes.getLength(); ++i) {
                Node entryNode = entryNodes.item(i);
                ModifiableModelAwareRepeaterEntry entryData = repeaterData.addEntry();
                NodeList subDataNodes = entryNode.getChildNodes();
                for (int j = 0; j < subDataNodes.getLength(); ++j) {
                    Node subDataNode = subDataNodes.item(j);
                    if (subDataNode.getNodeType() != 1) continue;
                    String subDataName = subDataNode.getLocalName();
                    ModelItem childDefinition = repeaterDefinition.getChild(subDataName);
                    this._importAttribute((ModifiableModelAwareDataHolder)entryData, childDefinition, subDataNode);
                }
            }
        }
    }

    private void _setComposite(ModifiableModelAwareDataHolder dataHolder, CompositeDefinition compositeDefinition, Node compositeNode) throws IOException {
        NodeList subDataNodes = compositeNode.getChildNodes();
        if (subDataNodes.getLength() > 0) {
            ModifiableModelAwareComposite compositeData = dataHolder.getComposite(compositeDefinition.getName(), true);
            for (int i = 0; i < subDataNodes.getLength(); ++i) {
                Node subDataNode = subDataNodes.item(i);
                if (subDataNode.getNodeType() != 1) continue;
                String subDataName = subDataNode.getLocalName();
                ModelItem childDefinition = compositeDefinition.getChild(subDataName);
                this._importAttribute((ModifiableModelAwareDataHolder)compositeData, childDefinition, subDataNode);
            }
        }
    }

    private <T> void _setAttribute(ModifiableModelAwareDataHolder dataHolder, ElementDefinition<T> attributeDefinition, Node attributeNode) throws IOException {
        ElementType type = attributeDefinition.getType();
        if (attributeDefinition.isMultiple()) {
            NodeList valuesNodeList = this._xPathProcessor.selectNodeList(attributeNode, "value");
            ArrayList values = new ArrayList();
            for (int i = 0; i < valuesNodeList.getLength(); ++i) {
                this._getSingleAttributeValue(valuesNodeList.item(i), type).ifPresent(value -> values.add(value));
            }
            if (!values.isEmpty()) {
                Object[] valuesAsArray = (Object[])Array.newInstance(type.getManagedClass(), values.size());
                dataHolder.setValue(attributeDefinition.getName(), (Object)values.toArray(valuesAsArray));
            }
        } else {
            this._getSingleAttributeValue(attributeNode, type).ifPresent(value -> dataHolder.setValue(attributeDefinition.getName(), value));
        }
    }

    private <T> Optional<T> _getSingleAttributeValue(Node valueNode, ElementType<T> type) throws IOException {
        String id = type.getId();
        if ("binary".equals(id) || "file".equals(id)) {
            return this._getSingleBinaryAttributeValue(valueNode);
        }
        if ("geocode".equals(id)) {
            return this._getSingleGeocodeAttributeValue(valueNode);
        }
        if ("rich-text".equals(id)) {
            return this._getSingleRichTextAttributeValue(valueNode);
        }
        return this._getSingleDefaultAttributeValue(valueNode, type);
    }

    private Optional<Geocode> _getSingleGeocodeAttributeValue(Node geocodeNode) {
        Node latitudeNode = this._xPathProcessor.selectSingleNode(geocodeNode, "latitude");
        String latitude = latitudeNode.getTextContent();
        Node longitudeNode = this._xPathProcessor.selectSingleNode(geocodeNode, "longitude");
        String longitude = longitudeNode.getTextContent();
        if (StringUtils.isNotEmpty((CharSequence)latitude) && StringUtils.isNotEmpty((CharSequence)longitude)) {
            return Optional.of(new Geocode(Double.valueOf(latitude), Double.valueOf(longitude)));
        }
        throw new IllegalArgumentException("Invalid geocode values: latitude='" + latitude + "', longitude='" + longitude + "'.");
    }

    private Optional<Binary> _getSingleBinaryAttributeValue(Node binaryNode) {
        String value = binaryNode.getTextContent();
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            Optional<Binary> optional;
            block13: {
                Pattern pattern = Pattern.compile("filename=\"([^\"]+)\"");
                URL url = new URL(value);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(2000);
                String contentType = StringUtils.defaultString((String)connection.getContentType(), (String)"application/unknown");
                String contentEncoding = StringUtils.defaultString((String)connection.getContentEncoding(), (String)"");
                String contentDisposition = StringUtils.defaultString((String)connection.getHeaderField("Content-Disposition"), (String)"");
                String filename = URIUtils.decode((String)FilenameUtils.getName((String)connection.getURL().getPath()));
                if (StringUtils.isEmpty((CharSequence)filename)) {
                    Matcher matcher = pattern.matcher(contentDisposition);
                    filename = matcher.matches() ? matcher.group(1) : "unknown";
                }
                InputStream is = connection.getInputStream();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                    Binary binary = new Binary();
                    binary.setLastModificationDate(ZonedDateTime.now());
                    binary.setInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));
                    if (StringUtils.isNotEmpty((CharSequence)filename)) {
                        binary.setFilename(filename);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)contentType)) {
                        binary.setMimeType(contentType);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)contentEncoding)) {
                        binary.setEncoding(contentEncoding);
                    }
                    optional = Optional.of(binary);
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to fetch file from URL '" + value + "', it will be ignored.", e);
                    }
                }
                is.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    private Optional<RichText> _getSingleRichTextAttributeValue(Node richTextNode) throws IOException {
        NodeList docbookNodes = richTextNode.getChildNodes();
        for (int i = 0; i < docbookNodes.getLength(); ++i) {
            Node docbookNode = docbookNodes.item(i);
            if (docbookNode.getNodeType() != 1 || !"article".equals(docbookNode.getLocalName())) continue;
            try {
                String docbook = this._serializeNode(docbookNode);
                RichText richText = new RichText();
                richText.setEncoding("UTF-8");
                richText.setLastModificationDate(ZonedDateTime.now());
                richText.setMimeType("text/xml");
                richText.setInputStream((InputStream)new ByteArrayInputStream(docbook.getBytes("UTF-8")));
                return Optional.of(richText);
            }
            catch (TransformerException e) {
                throw new IOException("Error serializing a docbook node.", e);
            }
        }
        return Optional.empty();
    }

    private String _serializeNode(Node node) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("encoding", "UTF-8");
        transformer.setOutputProperties(format);
        StringWriter writer = new StringWriter();
        DOMSource domSource = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(domSource, result);
        return writer.toString();
    }

    private <T> Optional<T> _getSingleDefaultAttributeValue(Node valueNode, ElementType<T> type) {
        String valueAsString = valueNode.getTextContent();
        return Optional.of(type.castValue((Object)valueAsString));
    }
}

