/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.archive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.ametys.cms.repository.DefaultContent;
import org.ametys.core.observation.Event;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ContentsArchiverHelper;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.ResourcesAdditionalDataGetter;
import org.ametys.plugins.contentio.archive.UnitaryImporter;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.plugins.repository.data.extractor.xml.ModelAwareXMLValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.webcontentio.archive.SitePluginArchiver;
import org.ametys.plugins.webcontentio.archive.SitemapImporter;
import org.ametys.plugins.webcontentio.archive.SitesArchiver;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.web.repository.ModifiableSiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class SiteImporter {
    final ImportReport _report = new ImportReport();
    private final SitesArchiver _siteArchiver;
    private final ModifiableTraversableAmetysObject _root;
    private final Path _zipArchivePath;
    private final Merger _merger;
    private final Logger _logger;
    private final DocumentBuilder _builder;

    SiteImporter(SitesArchiver siteArchiver, ModifiableTraversableAmetysObject root, Path zipArchivePath, Merger merger, Logger logger) throws ParserConfigurationException {
        this._siteArchiver = siteArchiver;
        this._root = root;
        this._zipArchivePath = zipArchivePath;
        this._merger = merger;
        this._logger = logger;
        this._builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    void importSites() throws IOException {
        Collection<Path> sitePaths = this._retrieveSites();
        for (Path sitePath : sitePaths) {
            String siteName = sitePath.getFileName().toString();
            this._importSite(sitePath, siteName);
        }
    }

    void importSite(String siteName) throws IOException {
        String prefix = "sites/" + NodeHelper.getFullHashPath((String)siteName);
        Path sitePath = ZipEntryHelper.zipFileRoot((Path)this._zipArchivePath).resolve(prefix);
        this._importSite(sitePath, siteName);
    }

    private Collection<Path> _retrieveSites() throws IOException {
        Collection<Path> sitePaths = new SiteRetriever().getThreeDepthPaths();
        return sitePaths;
    }

    private void _importSite(Path sitePath, String siteName) throws IOException {
        new UnitarySiteImporter(siteName).unitaryImport(this._zipArchivePath, sitePath, this._merger, this._logger);
    }

    private Document _getSitePropertiesXml(Path sitePath) throws IOException {
        Document document;
        block8: {
            String propertiesFileName = String.valueOf(sitePath.getFileName()) + ".xml";
            String zipEntryPath = sitePath.resolve(propertiesFileName).toString();
            InputStream stream = ZipEntryHelper.zipEntryFileInputStream((Path)this._zipArchivePath, (String)zipEntryPath);
            try {
                Document doc;
                document = doc = this._builder.parse(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
            stream.close();
        }
        return document;
    }

    private Site _createSite(Path sitePath, String id, String siteName, Document propertiesXml) throws ImportGlobalFailException, Archivers.AmetysObjectNotImportedException, RepositoryException, TransformerException, IOException, Exception {
        this._logger.info("Importing site from '{}!{}' ...", (Object)this._zipArchivePath, (Object)sitePath);
        Site site = this._createChildSite(id, siteName);
        site.setType(Archivers.xpathEvalNonEmpty((String)"site/@type", (org.w3c.dom.Node)propertiesXml));
        ResourcesAdditionalDataGetter additionalDataGetter = new ResourcesAdditionalDataGetter(this._zipArchivePath, sitePath);
        this._setSiteProperties(site, propertiesXml, (XMLValuesExtractorAdditionalDataGetter)additionalDataGetter);
        Archivers.unitarySave((Node)site.getNode(), (Logger)this._logger);
        ImportReport importResourceReport = this._importResources(site, sitePath);
        this._report.addFrom(importResourceReport);
        ImportReport importContentReport = this._importContents(site, sitePath, siteName);
        this._report.addFrom(importContentReport);
        ImportReport importPluginReport = this._importPlugins(site, sitePath);
        this._report.addFrom(importPluginReport);
        ImportReport importSitemapReport = this._importSitemaps(site, sitePath);
        this._report.addFrom(importSitemapReport);
        return site;
    }

    private Site _createChildSite(String id, String siteName) throws RepositoryException {
        String uuid = StringUtils.substringAfter((String)id, (String)"://");
        Node srcNode = ((Site)this._root.createChild(siteName, "ametys:site")).getNode();
        Node siteNode = Archivers.replaceNodeWithDesiredUuid((Node)srcNode, (String)uuid);
        return (Site)this._siteArchiver._resolver.resolve(this._root.getPath(), siteNode, null, false);
    }

    private void _setSiteProperties(Site site, Document propertiesXml, XMLValuesExtractorAdditionalDataGetter additionalDataGetter) throws TransformerException, Exception {
        Element siteElement = (Element)XPathAPI.selectSingleNode((org.w3c.dom.Node)propertiesXml, (String)"site");
        SiteType siteType = (SiteType)this._siteArchiver._siteTypeEP.getExtension(site.getType());
        View view = View.of((Model)siteType);
        Map values = new ModelAwareXMLValuesExtractor(siteElement, additionalDataGetter, new Model[]{siteType}).extractValues(view);
        site.getDataHolder().synchronizeValues((ViewItemAccessor)view, values);
    }

    private ImportReport _importResources(Site site, Path sitePath) throws IOException {
        String baseImportResourcePath = sitePath.resolve("resources").toString();
        if (ZipEntryHelper.zipEntryFolderExists((Path)this._zipArchivePath, (String)baseImportResourcePath)) {
            Node parentOfRootResources = site.getNode();
            return this._siteArchiver._resourcesArchiverHelper.importCollection(baseImportResourcePath + "/", parentOfRootResources, this._zipArchivePath, this._merger);
        }
        this._logger.info("No resource to be imported for Site '{}', the path '{}!{}' does not exist", new Object[]{site, this._zipArchivePath, baseImportResourcePath});
        return new ImportReport();
    }

    private ImportReport _importContents(Site site, Path sitePath, String siteName) throws IOException {
        AmetysObjectCollection rootContents = site.hasChild("ametys-internal:contents") ? (AmetysObjectCollection)site.getChild("ametys-internal:contents") : (AmetysObjectCollection)site.createChild("ametys-internal:contents", "ametys:collection");
        String baseImportContentPath = sitePath.resolve("contents").toString();
        if (ZipEntryHelper.zipEntryFolderExists((Path)this._zipArchivePath, (String)baseImportContentPath)) {
            Set<ContentsArchiverHelper.ContentFiller> contentFillers = Collections.singleton(content -> this._setWebAttributes(content, siteName));
            return this._siteArchiver._contentsArchiverHelper.importContents(baseImportContentPath + "/", rootContents, this._zipArchivePath, this._merger, contentFillers);
        }
        this._logger.info("No content to be imported for Site '{}', the path '{}!{}' does not exist", new Object[]{site, this._zipArchivePath, baseImportContentPath});
        return new ImportReport();
    }

    private void _setWebAttributes(DefaultContent content, String siteName) {
        if (content instanceof ModifiableSiteAwareAmetysObject) {
            this._logger.debug("Setting site name '{}' to freshly imported content {}", (Object)siteName, (Object)content);
            ((ModifiableSiteAwareAmetysObject)content).setSiteName(siteName);
        }
    }

    private ImportReport _importPlugins(Site site, Path sitePath) throws IOException, RepositoryException {
        DirectoryStream childPlugins;
        String baseImportPluginPath = sitePath.resolve("plugins").toString();
        if (!ZipEntryHelper.zipEntryFolderExists((Path)this._zipArchivePath, (String)baseImportPluginPath)) {
            this._logger.info("No plugin to be imported for Site '{}', the path '{}!{}' does not exist", new Object[]{site, this._zipArchivePath, baseImportPluginPath});
            return new ImportReport();
        }
        ArrayList<ImportReport> reports = new ArrayList<ImportReport>();
        try (DirectoryStream directoryStream = childPlugins = ZipEntryHelper.children((Path)this._zipArchivePath, Optional.of(baseImportPluginPath), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path childPlugin : childPlugins) {
                ImportReport importPluginReport = this._importPlugin(site, childPlugin);
                reports.add(importPluginReport);
            }
        }
        return ImportReport.union(reports);
    }

    private ImportReport _importPlugin(Site site, Path zipPluginEntryPath) throws IOException, RepositoryException {
        String pluginName = zipPluginEntryPath.getFileName().toString();
        SitePluginArchiver sitePluginArchiver = this._siteArchiver._retrieveSitePluginArchiver(pluginName);
        Node allPluginsNode = SitesArchiver._getAllPluginsNode(site);
        this._logger.info("Importing site plugin '{}' ({}!{}) from archive with archiver '{}'", new Object[]{pluginName, this._zipArchivePath, zipPluginEntryPath, sitePluginArchiver.getClass().getName()});
        String zipPluginEntryPathStr = zipPluginEntryPath.toString();
        return sitePluginArchiver.partialImport(site, pluginName, allPluginsNode, this._zipArchivePath, zipPluginEntryPathStr, this._merger);
    }

    private ImportReport _importSitemaps(Site site, Path sitePath) throws RepositoryException, IOException {
        DirectoryStream sitemaps;
        String baseImportSitemapPath = sitePath.resolve("pages").toString();
        if (!ZipEntryHelper.zipEntryFolderExists((Path)this._zipArchivePath, (String)baseImportSitemapPath)) {
            this._logger.info("No sitemap to be imported for Site '{}', the path '{}!{}' does not exist", new Object[]{site, this._zipArchivePath, baseImportSitemapPath});
            return new ImportReport();
        }
        ArrayList<ImportReport> reports = new ArrayList<ImportReport>();
        try (DirectoryStream directoryStream = sitemaps = ZipEntryHelper.children((Path)this._zipArchivePath, Optional.of(baseImportSitemapPath), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path sitemap : sitemaps) {
                SitemapImporter sitemapImporter = new SitemapImporter(this._siteArchiver, site, sitemap, this._zipArchivePath, this._merger, this._logger, this._builder);
                sitemapImporter.importSitemap();
                reports.add(sitemapImporter._report);
            }
        }
        return ImportReport.union(reports);
    }

    private final class SiteRetriever {
        private SiteRetriever() {
        }

        Collection<Path> getThreeDepthPaths() throws IOException {
            return this._getThreeDepthPaths("sites/", 0).collect(Collectors.toList());
        }

        private Stream<Path> _getThreeDepthPaths(String currentPath, int count) throws IOException {
            DirectoryStream nextLevels = ZipEntryHelper.children((Path)SiteImporter.this._zipArchivePath, Optional.of(currentPath), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            return this._getNextLevelPathDirectories(nextLevels, count);
        }

        private Stream<Path> _getThreeDepthPaths(Path currentPath, int count) throws IOException {
            if (count == 3) {
                return Stream.of(currentPath);
            }
            return this._getThreeDepthPaths(currentPath.toString(), count);
        }

        private Stream<Path> _getNextLevelPathDirectories(DirectoryStream<Path> currentLevels, int count) {
            return StreamSupport.stream(currentLevels.spliterator(), false).map(LambdaUtils.wrap(currentLevel -> this._getThreeDepthPaths((Path)currentLevel, count + 1))).flatMap(Function.identity());
        }
    }

    private class UnitarySiteImporter
    implements UnitaryImporter<Site> {
        private String _siteName;

        UnitarySiteImporter(String siteName) {
            this._siteName = siteName;
        }

        public String objectNameForLogs() {
            return "Site";
        }

        public Document getPropertiesXml(Path zipEntryPath) throws Exception {
            return SiteImporter.this._getSitePropertiesXml(zipEntryPath);
        }

        public String retrieveId(Document propertiesXml) throws Exception {
            return Archivers.xpathEvalNonEmpty((String)"site/@id", (org.w3c.dom.Node)propertiesXml);
        }

        public Site create(Path zipEntryPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
            return SiteImporter.this._createSite(zipEntryPath, id, this._siteName, propertiesXml);
        }

        public ImportReport getReport() {
            return SiteImporter.this._report;
        }

        public void unitaryImportFinalize() {
            SiteImporter.this._siteArchiver._siteManager.clearCache();
            Site site = SiteImporter.this._siteArchiver._siteManager.getSite(this._siteName);
            HashMap<String, Site> eventParams = new HashMap<String, Site>();
            eventParams.put("site", site);
            SiteImporter.this._siteArchiver._observationManager.notify(new Event("site.added", SiteImporter.this._siteArchiver._currentUserProvider.getUser(), eventParams));
            super.unitaryImportFinalize();
        }
    }
}

