/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.archive;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.contentio.archive.Archiver;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ContentsArchiverHelper;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.ManifestReaderWriter;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.PartialImport;
import org.ametys.plugins.contentio.archive.ResourcesArchiverHelper;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.webcontentio.archive.SiteImporter;
import org.ametys.plugins.webcontentio.archive.SitePluginArchiver;
import org.ametys.plugins.webcontentio.archive.SitePluginArchiverExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.page.jcr.DefaultPageFactory;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.site.SiteTypesExtensionPoint;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.repository.sitemap.SitemapFactory;
import org.ametys.web.service.ServiceExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.IntegerSequence;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SitesArchiver
extends AbstractLogEnabled
implements Archiver,
Serviceable {
    public static final String ID = "sites";
    static final String __SITE_RESOURCES_JCR_NODE_NAME = "ametys-internal:resources";
    static final String __SITE_CONTENTS_JCR_NODE_NAME = "ametys-internal:contents";
    static final String __SITE_PLUGINS_JCR_NODE_NAME = "ametys-internal:plugins";
    static final String __COMMON_PREFIX = "sites/";
    static final String __ACL_ZIP_ENTRY_FILENAME = "acl.xml";
    private static final String __PARTIAL_IMPORT_PREFIX = "sites/";
    protected SiteManager _siteManager;
    protected ContentsArchiverHelper _contentsArchiverHelper;
    protected ResourcesArchiverHelper _resourcesArchiverHelper;
    protected SitePluginArchiverExtensionPoint _pluginArchiverExtensionPoint;
    protected TagProviderExtensionPoint _tagProviderEP;
    protected AmetysObjectResolver _resolver;
    protected DefaultPageFactory _defaultPageFactory;
    protected SitemapFactory _sitemapFactory;
    protected ServiceExtensionPoint _serviceExtensionPoint;
    protected SiteTypesExtensionPoint _siteTypeEP;
    protected ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    private ManifestReaderWriter _manifestReaderWriter = new SitesArchiverManifestReaderWriter();

    public void service(ServiceManager manager) throws ServiceException {
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._contentsArchiverHelper = (ContentsArchiverHelper)manager.lookup(ContentsArchiverHelper.ROLE);
        this._resourcesArchiverHelper = (ResourcesArchiverHelper)manager.lookup(ResourcesArchiverHelper.ROLE);
        this._pluginArchiverExtensionPoint = (SitePluginArchiverExtensionPoint)((Object)manager.lookup(SitePluginArchiverExtensionPoint.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)manager.lookup(TagProviderExtensionPoint.ROLE);
        AmetysObjectFactoryExtensionPoint ametysObjectFactoryEP = (AmetysObjectFactoryExtensionPoint)manager.lookup(AmetysObjectFactoryExtensionPoint.ROLE);
        this._defaultPageFactory = (DefaultPageFactory)ametysObjectFactoryEP.getExtension(DefaultPageFactory.class.getName());
        this._sitemapFactory = (SitemapFactory)ametysObjectFactoryEP.getExtension(SitemapFactory.class.getName());
        this._serviceExtensionPoint = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
        this._siteTypeEP = (SiteTypesExtensionPoint)manager.lookup(SiteTypesExtensionPoint.ROLE);
        this._pageDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_PAGE_DATA);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public ManifestReaderWriter getManifestReaderWriter() {
        return this._manifestReaderWriter;
    }

    public void export(ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry("sites/"));
        try (AmetysObjectIterable sites = this._siteManager.getSites();){
            for (Site site : sites) {
                this.getLogger().info("Processing site '{}' for archiving", (Object)site.getName());
                this._exportSite(site, zos);
            }
        }
    }

    private void _exportSite(Site site, ZipOutputStream zos) throws IOException {
        String siteName = site.getName();
        String prefix = "sites/" + NodeHelper.getFullHashPath((String)siteName);
        ZipEntry siteEntry = new ZipEntry(prefix + "/" + siteName + ".xml");
        zos.putNextEntry(siteEntry);
        try {
            TransformerHandler contentHandler = Archivers.newTransformerHandler();
            contentHandler.setResult(new StreamResult(zos));
            contentHandler.startDocument();
            Attributes attrs = this._getSiteAttributes(site);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"site", (Attributes)attrs);
            site.dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"site");
            contentHandler.endDocument();
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX site '" + site.getPath() + "' for archiving", e);
        }
        ResourceCollection rootResources = (ResourceCollection)site.getChild(__SITE_RESOURCES_JCR_NODE_NAME);
        this._resourcesArchiverHelper.exportCollection(rootResources, zos, prefix + "/resources/");
        Archivers.exportBinaries((ModelAwareDataHolder)site, (ZipOutputStream)zos, (String)(prefix + "/"));
        TraversableAmetysObject rootContents = (TraversableAmetysObject)site.getChild(__SITE_CONTENTS_JCR_NODE_NAME);
        this._contentsArchiverHelper.exportContents(prefix + "/contents/", rootContents, zos);
        try {
            SitesArchiver._getPluginNodes(site).forEachRemaining(LambdaUtils.wrapConsumer(pluginNode -> this._exportPlugin(site, (Node)pluginNode, zos, prefix)));
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Unable to archive plugins for site " + siteName, e);
        }
        this._exportSitemaps(site, zos, prefix, siteName);
    }

    private Attributes _getSiteAttributes(Site site) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", site.getId());
        attrs.addCDATAAttribute("type", site.getType());
        return attrs;
    }

    static Node _getAllPluginsNode(Site site) throws RepositoryException {
        return site.getNode().getNode(__SITE_PLUGINS_JCR_NODE_NAME);
    }

    private static Iterator<Node> _getPluginNodes(Site site) throws RepositoryException {
        return SitesArchiver._getAllPluginsNode(site).getNodes();
    }

    SitePluginArchiver _retrieveSitePluginArchiver(String pluginName) {
        SitePluginArchiver sitePluginArchiver = (SitePluginArchiver)this._pluginArchiverExtensionPoint.getExtension(pluginName);
        if (sitePluginArchiver == null && (sitePluginArchiver = (SitePluginArchiver)this._pluginArchiverExtensionPoint.getExtension("__default")) == null) {
            throw new IllegalStateException("There sould be a '__default' extension to SitePluginArchiverExtensionPoint. Please check your excluded features.");
        }
        return sitePluginArchiver;
    }

    private void _exportPlugin(Site site, Node pluginNode, ZipOutputStream zos, String prefix) throws Exception {
        String pluginName = pluginNode.getName();
        SitePluginArchiver sitePluginArchiver = this._retrieveSitePluginArchiver(pluginName);
        this.getLogger().info("Processing plugin '{}' for site '{}' for archiving at {} with archiver '{}'", new Object[]{pluginName, site.getName(), pluginNode, sitePluginArchiver.getClass().getName()});
        sitePluginArchiver.export(site, pluginName, pluginNode, zos, prefix + "/plugins/" + pluginName);
    }

    private void _exportSitemaps(Site site, ZipOutputStream zos, String prefix, String siteName) throws IOException {
        try (AmetysObjectIterable sitemaps = site.getSitemaps();){
            for (Sitemap sitemap : sitemaps) {
                this._exportSitemap(sitemap, zos, prefix);
            }
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Unable to archive pages for site " + siteName, e);
        }
    }

    private void _exportSitemap(Sitemap sitemap, ZipOutputStream zos, String prefix) throws IOException, RepositoryException {
        String sitemapPrefix = prefix + "/pages/" + sitemap.getName();
        zos.putNextEntry(new ZipEntry(sitemapPrefix + "/"));
        this._exportSitemapData(sitemap, zos, sitemapPrefix);
        Stream nodes = Streams.stream(SitesArchiver._getSitemapChildrenNodes(sitemap));
        IntegerSequence.Incrementor orderIncrementor = IntegerSequence.Incrementor.create().withStart(0).withMaximalCount(Integer.MAX_VALUE);
        nodes.filter(LambdaUtils.wrapPredicate(node -> node.isNodeType("ametys:page"))).forEachOrdered(LambdaUtils.wrapConsumer(pageNode -> {
            this._exportPage((Node)pageNode, zos, sitemapPrefix, orderIncrementor.getCount());
            orderIncrementor.increment();
        }));
    }

    private void _exportSitemapData(Sitemap sitemap, ZipOutputStream zos, String sitemapPrefix) throws RepositoryException, IOException {
        ZipEntry siteEntry = new ZipEntry(sitemapPrefix + ".xml");
        zos.putNextEntry(siteEntry);
        try {
            TransformerHandler contentHandler = Archivers.newTransformerHandler();
            contentHandler.setResult(new StreamResult(zos));
            contentHandler.startDocument();
            Attributes attrs = this._getSitemapAttributes(sitemap);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"sitemap", (Attributes)attrs);
            this._saxAmetysInternalProperties((SitemapElement)sitemap, contentHandler);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"attributes");
            sitemap.dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"attributes");
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"sitemap");
            contentHandler.endDocument();
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX sitemap '" + sitemap.getPath() + "' for archiving", e);
        }
        Archivers.exportAcl((Node)sitemap.getNode(), (ZipOutputStream)zos, (String)("_metadata/" + sitemapPrefix + "/acl.xml"));
    }

    private Attributes _getSitemapAttributes(Sitemap sitemap) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("name", sitemap.getName());
        attrs.addCDATAAttribute("id", sitemap.getId());
        return attrs;
    }

    private static Iterator<Node> _getSitemapChildrenNodes(Sitemap sitemap) throws RepositoryException {
        return sitemap.getNode().getNodes();
    }

    private void _exportPage(Node pageNode, ZipOutputStream zos, String prefix, int order) throws RepositoryException, IOException {
        String pageName = pageNode.getName();
        Page page = (Page)this._resolver.resolve(pageNode, false);
        String pagePrefix = prefix + "/" + pageName;
        ZipEntry siteEntry = new ZipEntry(pagePrefix + ".xml");
        zos.putNextEntry(siteEntry);
        try {
            TransformerHandler contentHandler = Archivers.newTransformerHandler();
            contentHandler.setResult(new StreamResult(zos));
            contentHandler.startDocument();
            Attributes attrs = this._getPageAttributes(page, order);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"page", (Attributes)attrs);
            this._saxAmetysInternalProperties((SitemapElement)page, contentHandler);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"attributes");
            page.dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"attributes");
            this._saxTags(page, contentHandler);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"templateParameters");
            page.getTemplateParametersHolder().dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"templateParameters");
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"pageContents");
            this._saxZones(page, contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"pageContents");
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"page");
            contentHandler.endDocument();
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX page '" + page.getPath() + "' for archiving", e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to process Page for archiving: " + page.getId(), e);
        }
        this._saxAttachments(page, pagePrefix, zos);
        Archivers.exportAcl((Node)pageNode, (ZipOutputStream)zos, (String)("_metadata/" + pagePrefix + "/acl.xml"));
        Stream nodes = Streams.stream(SitesArchiver._getPageChildrenNodes(pageNode));
        IntegerSequence.Incrementor orderIncrementor = IntegerSequence.Incrementor.create().withStart(0).withMaximalCount(Integer.MAX_VALUE);
        nodes.filter(LambdaUtils.wrapPredicate(node -> node.isNodeType("ametys:page"))).forEachOrdered(LambdaUtils.wrapConsumer(node -> {
            this._exportPage((Node)node, zos, pagePrefix, orderIncrementor.getCount());
            orderIncrementor.increment();
        }));
    }

    private Attributes _getPageAttributes(Page page, int order) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("title", page.getTitle());
        attrs.addCDATAAttribute("long-title", page.getLongTitle());
        attrs.addCDATAAttribute("id", page.getId());
        attrs.addCDATAAttribute("type", page.getType().toString());
        attrs.addCDATAAttribute("order", Integer.toString(order));
        if (page.getType() == Page.PageType.LINK) {
            attrs.addCDATAAttribute("url", page.getURL());
            attrs.addCDATAAttribute("urlType", page.getURLType().toString());
        } else if (page.getType() == Page.PageType.CONTAINER) {
            attrs.addCDATAAttribute("template", page.getTemplate());
        }
        return attrs;
    }

    private void _saxAmetysInternalProperties(SitemapElement sitemapElement, TransformerHandler contentHandler) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"internal");
        if (sitemapElement instanceof JCRAmetysObject) {
            Node node = ((JCRAmetysObject)sitemapElement).getNode();
            try {
                this._saxInternalPropeties(node, contentHandler, "ametys-internal:virtual");
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"internal");
    }

    private void _saxInternalPropeties(Node node, TransformerHandler contentHandler, String ... properties) throws RepositoryException, SAXException {
        for (String propertyName : properties) {
            if (!node.hasProperty(propertyName)) continue;
            Property property = node.getProperty(propertyName);
            for (Value value : property.getValues()) {
                String propertyValue = value.getString();
                XMLUtils.createElement((ContentHandler)contentHandler, (String)propertyName, (String)propertyValue);
            }
        }
    }

    private void _saxTags(Page page, TransformerHandler contentHandler) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"tags");
        Set tags = page.getTags();
        for (String tagName : tags) {
            HashMap<String, String> contextParameters = new HashMap<String, String>();
            contextParameters.put("siteName", page.getSiteName());
            Tag tag = this._tagProviderEP.getTag(tagName, contextParameters);
            if (tag == null) continue;
            XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"tags");
    }

    private void _saxAttachments(Page page, String pagePrefix, ZipOutputStream zos) throws IOException {
        String prefix = "_metadata/" + pagePrefix + "/_attachments/";
        this._resourcesArchiverHelper.exportCollection(page.getRootAttachments(), zos, prefix);
    }

    private void _saxZones(Page page, TransformerHandler contentHandler) throws SAXException {
        for (Zone zone : page.getZones()) {
            this._saxZone(zone, contentHandler);
        }
    }

    private void _saxZone(Zone zone, TransformerHandler contentHandler) throws SAXException {
        try {
            String zoneName = zone.getName();
            AttributesImpl zoneAttrs = new AttributesImpl();
            zoneAttrs.addCDATAAttribute("name", zoneName);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"zone", (Attributes)zoneAttrs);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"attributes");
            zone.dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"attributes");
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"zoneParameters");
            zone.getZoneParametersHolder().dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"zoneParameters");
            AmetysObjectIterable zoneItems = zone.getZoneItems();
            this._saxZoneItems((AmetysObjectIterable<? extends ZoneItem>)zoneItems, contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"zone");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to process Zone for archiving: " + zone.getId(), e);
        }
    }

    private void _saxZoneItems(AmetysObjectIterable<? extends ZoneItem> zoneItems, TransformerHandler contentHandler) throws SAXException {
        for (ZoneItem zoneItem : zoneItems) {
            try {
                this._saxZoneItem(zoneItem, contentHandler);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Unable to process ZoneItem for archiving: " + zoneItem.getId(), e);
            }
        }
    }

    private void _saxZoneItem(ZoneItem zoneItem, TransformerHandler contentHandler) throws SAXException {
        ZoneItem.ZoneType zoneType = zoneItem.getType();
        Attributes zoneItemAttrs = this._getZoneItemAttributes(zoneItem, zoneType);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"zoneItem", (Attributes)zoneItemAttrs);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"attributes");
        zoneItem.dataToSAX((ContentHandler)contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"attributes");
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"zoneItemParameters");
        zoneItem.getZoneItemParametersHolder().dataToSAX((ContentHandler)contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"zoneItemParameters");
        if (zoneType == ZoneItem.ZoneType.SERVICE) {
            ModelAwareDataHolder serviceParameters = this._getServiceParameters(zoneItem);
            if (serviceParameters != null) {
                ModelAwareDataHolder serviceViewParameters;
                String viewName;
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"serviceParameters");
                serviceParameters.dataToSAX((ContentHandler)contentHandler);
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"serviceParameters");
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"serviceViewParameters");
                if (serviceParameters.hasDefinition("xslt") && StringUtils.isNotBlank((CharSequence)(viewName = (String)serviceParameters.getValue("xslt"))) && (serviceViewParameters = zoneItem.getServiceViewParametersHolder(viewName)) != null) {
                    serviceViewParameters.dataToSAX((ContentHandler)contentHandler);
                }
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"serviceViewParameters");
            }
        } else if (zoneType == ZoneItem.ZoneType.CONTENT) {
            String viewName = (String)StringUtils.defaultIfBlank((CharSequence)zoneItem.getViewName(), (CharSequence)"main");
            ModelAwareDataHolder contentViewParameters = zoneItem.getContentViewParametersHolder(viewName);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"contentViewParameters");
            contentViewParameters.dataToSAX((ContentHandler)contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"contentViewParameters");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"zoneItem");
    }

    private ModelAwareDataHolder _getServiceParameters(ZoneItem zoneItem) {
        try {
            return zoneItem.getServiceParameters();
        }
        catch (Exception e) {
            this.getLogger().error("Cannot get service parameters for ZoneItem \"{}\"", (Object)zoneItem, (Object)e);
            return null;
        }
    }

    private Attributes _getZoneItemAttributes(ZoneItem zoneItem, ZoneItem.ZoneType zoneType) {
        AttributesImpl zoneItemAttrs = new AttributesImpl();
        zoneItemAttrs.addCDATAAttribute("type", zoneType.toString());
        if (zoneType == ZoneItem.ZoneType.CONTENT) {
            zoneItemAttrs.addCDATAAttribute("contentId", zoneItem.getContent().getId());
            String viewName = zoneItem.getViewName();
            if (viewName != null) {
                zoneItemAttrs.addCDATAAttribute("viewName", viewName);
            }
        } else if (zoneType == ZoneItem.ZoneType.SERVICE) {
            zoneItemAttrs.addCDATAAttribute("serviceId", zoneItem.getServiceId());
        }
        return zoneItemAttrs;
    }

    private static Iterator<Node> _getPageChildrenNodes(Node pageNode) throws RepositoryException {
        return pageNode.getNodes();
    }

    public List<I18nizableText> additionalSuccessImportMail() {
        return List.of(new I18nizableText("plugin.web-contentio", "PLUGINS_WEB_CONTENTIO_ARCHIVE_IMPORT_SITE_ARCHIVER_MAIL_ADDITIONAL_BODY_REBUILD_LIVE"), new I18nizableText("plugin.web-contentio", "PLUGINS_WEB_CONTENTIO_ARCHIVE_IMPORT_SITE_ARCHIVER_MAIL_ADDITIONAL_BODY_SITE_TOOL"));
    }

    public Collection<String> managedPartialImports(Collection<String> partialImports) {
        if (partialImports.contains(ID)) {
            return Collections.singletonList(ID);
        }
        return partialImports.stream().filter(partialImport -> partialImport.startsWith("sites/")).collect(Collectors.toList());
    }

    public ImportReport partialImport(Path zipPath, Collection<String> partialImports, Merger merger, boolean deleteBefore) throws IOException {
        ModifiableTraversableAmetysObject siteRoot = this._siteManager.getRoot();
        if (deleteBefore && siteRoot instanceof JCRAmetysObject) {
            this._deleteBeforePartialImport(siteRoot, partialImports);
        }
        ImportReport result = this._partialImport(zipPath, partialImports, merger, siteRoot);
        this._saveImported((ModifiableAmetysObject)siteRoot);
        return result;
    }

    private void _deleteBeforePartialImport(ModifiableTraversableAmetysObject siteRoot, Collection<String> partialImports) throws IOException {
        if (!(siteRoot instanceof JCRAmetysObject)) {
            return;
        }
        JCRAmetysObject jcrSiteRoot = (JCRAmetysObject)siteRoot;
        if (partialImports.contains(ID)) {
            this._deleteSiteRootBeforePartialImport(jcrSiteRoot);
        } else {
            for (String siteName : this._retrieveSiteNames(partialImports)) {
                this._deleteSiteBeforePartialImport(siteName);
            }
        }
    }

    private void _deleteSiteRootBeforePartialImport(JCRAmetysObject siteRoot) throws IOException {
        try {
            Node rootNode = siteRoot.getNode();
            NodeIterator rootChildren = rootNode.getNodes();
            while (rootChildren.hasNext()) {
                rootChildren.nextNode().remove();
            }
            rootNode.getSession().save();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    private void _deleteSiteBeforePartialImport(String siteName) throws IOException {
        if (this._siteManager.hasSite(siteName)) {
            Node siteNode = this._siteManager.getSite(siteName).getNode();
            try {
                Session parentNodeSession = siteNode.getParent().getSession();
                siteNode.remove();
                parentNodeSession.save();
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }

    private Collection<String> _retrieveSiteNames(Collection<String> partialImports) {
        return partialImports.stream().map(partialImport -> StringUtils.substringAfter((String)partialImport, (String)"sites/")).collect(Collectors.toList());
    }

    private ImportReport _partialImport(Path zipPath, Collection<String> partialImports, Merger merger, ModifiableTraversableAmetysObject siteRoot) throws IOException {
        try {
            SiteImporter importer = new SiteImporter(this, siteRoot, zipPath, merger, this.getLogger());
            if (partialImports.contains(ID)) {
                importer.importSites();
            } else {
                for (String siteName : this._retrieveSiteNames(partialImports)) {
                    importer.importSite(siteName);
                }
            }
            return importer._report;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private void _saveImported(ModifiableAmetysObject siteRoot) {
        if (siteRoot.needsSave()) {
            this.getLogger().warn("{} still has pending changes while we should have saved unitarily every object. Another save will be done, but it is not normal.", (Object)siteRoot);
            siteRoot.saveChanges();
        }
    }

    private final class SitesArchiverManifestReaderWriter
    implements ManifestReaderWriter {
        private SitesArchiverManifestReaderWriter() {
        }

        public Object getData() {
            return SitesArchiver.this._siteManager.getSiteNames();
        }

        public Stream<PartialImport> toPartialImports(Object data) {
            return Stream.concat(this._allSitesToPartialImports(), this._sitesDataToPartialImports(data));
        }

        private Stream<PartialImport> _allSitesToPartialImports() {
            return Stream.of(PartialImport.of((String)SitesArchiver.ID, (I18nizableText)new I18nizableText("plugin.web-contentio", "PLUGINS_WEB_CONTENTIO_ARCHIVE_IMPORT_SITE_ARCHIVER_OPTION_ALL")));
        }

        private Stream<PartialImport> _sitesDataToPartialImports(Object data) {
            return Optional.ofNullable(data).filter(Collection.class::isInstance).map(this::_castToCollection).orElseGet(() -> {
                SitesArchiver.this.getLogger().warn("Unexpected manifest data '{}', we would expect an array representing the site names. The ZIP archive probably comes from a different version of Ametys.", data);
                return Collections.emptySet();
            }).stream().sorted().map(this::_toPartialImport);
        }

        private Collection<String> _castToCollection(Object data) {
            return (Collection)Collection.class.cast(data);
        }

        private PartialImport _toPartialImport(String siteName) {
            String key = "sites/" + siteName;
            return PartialImport.of((String)key, (I18nizableText)this._toPartialImportLabel(siteName));
        }

        private I18nizableText _toPartialImportLabel(String siteName) {
            return new I18nizableText("plugin.web-contentio", "PLUGINS_WEB_CONTENTIO_ARCHIVE_IMPORT_SITE_ARCHIVER_OPTION_ONE_SITE", Map.of("siteName", new I18nizableText(siteName)));
        }
    }
}

