<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns="http://docbook.org/ns/docbook"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
    xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
    xmlns:rels="http://schemas.openxmlformats.org/package/2006/relationships"
    xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main"
    xmlns:pic="http://schemas.openxmlformats.org/drawingml/2006/picture"
    xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
    xmlns:math="java.lang.Math"
	exclude-result-prefixes="w r rels a pic wp math">

	<xsl:template match="/">
        <xsl:apply-templates select="document/w:document/w:body"/>
	</xsl:template>
	
	<xsl:template match="w:body">
	    <article>
            <!--
                Generates content only after the content "header" containing illustration, abstract, ...
                We only consider w:p containing w:r and w:tbl
            -->
            <xsl:variable name="abstract" select="w:sdt[w:sdtPr/w:alias/@w:val='abstract']"/>
            <xsl:variable name="title" select="w:p[w:pPr/w:pStyle/@w:val='Titre'][1]"/>
            
            <xsl:choose>
                <xsl:when test="$abstract"> 
                    <xsl:apply-templates select="$abstract/following-sibling::w:p[w:r|w:hyperlink]|$abstract/following-sibling::w:tbl"/>
                </xsl:when>
                <xsl:when test="$title"> 
                    <xsl:apply-templates select="$title/following-sibling::w:p[w:r|w:hyperlink]|$title/following-sibling::w:tbl"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="w:p[w:r|w:hyperlink]|w:tbl"/>
                </xsl:otherwise>
            </xsl:choose>
	    </article>
	</xsl:template>
	
	<xsl:template match="w:p">
        <xsl:variable name="style" select="w:pPr/w:pStyle/@w:val"/>
        <xsl:variable name="outlineLevel" select="/document/w:styles/w:style[@w:styleId=$style]/w:pPr/w:outlineLvl/@w:val"/>
        
        <!--
            We only consider lists, titles and standard paragraphs
            If a liste contains titles, data is kept but not the titles themselves
        -->
        <xsl:choose>
            <xsl:when test="w:pPr/w:numPr">
                <xsl:variable name="listId" select="w:pPr/w:numPr/w:numId/@w:val"/>
                <xsl:variable name="indentLvl" select="w:pPr/w:numPr/w:ilvl/@w:val"/>
                
                <!--
                    The current paragraph initiates a new list if :
                     - there is no preceding paragraph with the same list number
                     - OR the preceding paragraph with the same list number has an indent Level lower than the current indent Level
                -->
                <xsl:if test="not(preceding-sibling::w:p[w:pPr/w:numPr[w:numId/@w:val = $listId]]) or preceding-sibling::w:p[w:pPr/w:numPr[w:numId/@w:val = $listId]][1]/w:pPr/w:numPr/w:ilvl/@w:val &lt; $indentLvl"> 
                    <xsl:variable name="listAbstractId" select="/document/w:numbering/w:num[@w:numId = $listId]/w:abstractNumId/@w:val" />
                    <xsl:variable name="listType">
                        <xsl:choose>
                            <xsl:when test="/document/w:numbering/w:abstractNum[@w:abstractNumId = $listAbstractId]/w:lvl[@w:ilvl = $indentLvl]/w:numFmt/@w:val='bullet'">itemizedlist</xsl:when>
                            <xsl:otherwise>orderedlist</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    
                    <xsl:if test="$indentLvl &gt; 0">
                        <xsl:text disable-output-escaping="yes">&lt;listitem&gt;</xsl:text>
                        <xsl:text disable-output-escaping="yes">&lt;para&gt;</xsl:text>
                    </xsl:if>
                    
                    <xsl:value-of disable-output-escaping="yes" select="concat('&lt;', $listType, '&gt;')"/>
                </xsl:if>
                
                <listitem>
                    <para>
                        <xsl:call-template name="para-content"/>
                    </para>
                </listitem>
                
                <!--
                    The current paragraph ends a list if :
                     - there is no following paragraph with the same list number
                     - OR the following paragraph with the same list number has an indent Level lower than the current indent Level
                -->
                <xsl:if test="not(following-sibling::w:p[w:pPr/w:numPr[w:numId/@w:val = $listId]]) or following-sibling::w:p[w:pPr/w:numPr[w:numId/@w:val = $listId]][1]/w:pPr/w:numPr/w:ilvl/@w:val &lt; $indentLvl"> 
                    <xsl:variable name="listAbstractId" select="/document/w:numbering/w:num[@w:numId = $listId]/w:abstractNumId/@w:val" />
                    <xsl:variable name="listType">
                        <xsl:choose>
                            <xsl:when test="/document/w:numbering/w:abstractNum[@w:abstractNumId = $listAbstractId]/w:lvl[@w:ilvl = $indentLvl]/w:numFmt/@w:val='bullet'">itemizedlist</xsl:when>
                            <xsl:otherwise>orderedlist</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    
                    <xsl:value-of disable-output-escaping="yes" select="concat('&lt;/', $listType, '&gt;')"/>
                    
                    <xsl:if test="$indentLvl &gt; 0">
                        <xsl:text disable-output-escaping="yes">&lt;/para&gt;</xsl:text>
                        <xsl:text disable-output-escaping="yes">&lt;/listitem&gt;</xsl:text>
                    </xsl:if>
                </xsl:if>
            </xsl:when>
            <!--
                Consider only sections at the root
            -->
            <xsl:when test="not(ancestor::w:tbl) and $outlineLevel &lt;= 6">
                <section level="{$outlineLevel + 1}">
                    <title>
                        <xsl:call-template name="para-content"/>
                    </title>
                </section>
            </xsl:when>
            <xsl:otherwise>
                <para>
                    <xsl:call-template name="para-content"/>
                </para>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
    
    <xsl:template name="para-content">
        <xsl:choose>
            <xsl:when test="w:pPr/w:jc/@w:val = 'right' or w:pPr/w:jc/@w:val = 'center'">
                <xsl:attribute name="align"><xsl:value-of select="w:pPr/w:jc/@w:val"/></xsl:attribute>
            </xsl:when>
            <xsl:when test="w:pPr/w:jc/@w:val = 'both' ">
                <xsl:attribute name="align">justify</xsl:attribute>
            </xsl:when>
        </xsl:choose>
            
        <xsl:apply-templates select="w:r|w:hyperlink"/>
    </xsl:template>
    
    <xsl:template match="w:r">
        <xsl:if test="w:rPr/w:b"><xsl:text disable-output-escaping="yes">&lt;emphasis role="strong"&gt;</xsl:text></xsl:if>
        <xsl:if test="w:rPr/w:i"><xsl:text disable-output-escaping="yes">&lt;emphasis&gt;</xsl:text></xsl:if>
        <xsl:if test="w:rPr/w:vertAlign/@w:val='subscript'"><xsl:text disable-output-escaping="yes">&lt;subscript&gt;</xsl:text></xsl:if>
        <xsl:if test="w:rPr/w:vertAlign/@w:val='superscript'"><xsl:text disable-output-escaping="yes">&lt;supscript&gt;</xsl:text></xsl:if>
        <xsl:apply-templates select="w:t|w:drawing/*/a:graphic|w:br"/>
        <xsl:if test="w:rPr/w:vertAlign/@w:val='superscript'"><xsl:text disable-output-escaping="yes">&lt;/supscript&gt;</xsl:text></xsl:if>
        <xsl:if test="w:rPr/w:vertAlign/@w:val='subscript'"><xsl:text disable-output-escaping="yes">&lt;/subscript&gt;</xsl:text></xsl:if>
        <xsl:if test="w:rPr/w:i"><xsl:text disable-output-escaping="yes">&lt;/emphasis&gt;</xsl:text></xsl:if>
        <xsl:if test="w:rPr/w:b"><xsl:text disable-output-escaping="yes">&lt;/emphasis&gt;</xsl:text></xsl:if>
    </xsl:template>
    
    <xsl:template match="w:t">
        <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="w:br">
        <phrase role="linebreak"/>
    </xsl:template>
    
    <xsl:template match="a:graphic">
        <xsl:variable name="rel" select="/document/rels:Relationships/rels:Relationship[@Id=current()/../wp:docPr/a:hlinkClick/@r:id]"/>
        <xsl:variable name="alt" select="../wp:docPr/@title"/>
    
        <xsl:choose>
            <xsl:when test="$rel/@TargetMode='External' and (starts-with($rel/@Target, 'mailto:') or contains($rel/@Target, '://'))">
                <link xlink:href="{$rel/@Target}">
                    <mediaobject>
                        <xsl:if test="$alt != ''">
                            <alt><xsl:value-of select="$alt"/></alt>
                        </xsl:if>
                        <xsl:apply-templates select="a:graphicData/pic:pic"/>
                    </mediaobject>
                </link>
            </xsl:when>
            <xsl:otherwise>
                <mediaobject>
                    <xsl:if test="$alt != ''">
                        <alt><xsl:value-of select="$alt"/></alt>
                    </xsl:if>
                    <xsl:apply-templates select="a:graphicData/pic:pic"/>
                </mediaobject>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="pic:pic">
        <xsl:variable name="picName" select="pic:nvPicPr/pic:cNvPr/@name"/>
        <xsl:variable name="fileName">
            <xsl:choose>
                <xsl:when test="not(preceding::pic:pic[pic:nvPicPr/pic:cNvPr/@name = $picName])"><xsl:value-of select="$picName"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="concat($picName, ' ', count(preceding::pic:pic[pic:nvPicPr/pic:cNvPr/@name = $picName]) + 1)"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <imageobject>
            <imagedata fileref="{/document/rels:Relationships/rels:Relationship[@Id=current()/pic:blipFill/a:blip/@r:embed]/@Target}" type="local" filename="{$fileName}">
                <xsl:attribute name="width"><xsl:value-of select="math:round(../../../wp:extent/@cx div 10000)"/>px</xsl:attribute>
                <xsl:attribute name="depth"><xsl:value-of select="math:round(../../../wp:extent/@cy div 10000)"/>px</xsl:attribute>
            </imagedata>
        </imageobject>
    </xsl:template>
    
    <xsl:template match="w:hyperlink">
        <xsl:variable name="rel" select="/document/rels:Relationships/rels:Relationship[@Id=current()/@r:id]"/>
        
        <xsl:choose>
            <xsl:when test="$rel/@TargetMode='External' and (starts-with($rel/@Target, 'mailto:') or contains($rel/@Target, '://'))">
                <link xlink:href="{$rel/@Target}">
                    <xsl:apply-templates select="w:r"/>
                </link>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="w:r"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="w:tbl">
        <table>
            <xsl:if test="w:tblPr/w:tblCaption/@w:val != ''">
                <xsl:attribute name="title"><xsl:value-of select="w:tblPr/w:tblCaption/@w:val"/></xsl:attribute>
            </xsl:if>
            
            <xsl:if test="w:tblPr/w:tblDescription/@w:val != ''">
                <xsl:attribute name="summary"><xsl:value-of select="w:tblPr/w:tblDescription/@w:val"/></xsl:attribute>
            </xsl:if>
            
            <xsl:choose>
                <xsl:when test="w:pPr/w:jc/@w:val = 'right' or w:pPr/w:jc/@w:val = 'center'">
                    <xsl:attribute name="align"><xsl:value-of select="w:pPr/w:jc/@w:val"/></xsl:attribute>
                </xsl:when>
                <xsl:when test="w:pPr/w:jc/@w:val = 'both' ">
                    <xsl:attribute name="align">justify</xsl:attribute>
                </xsl:when>
            </xsl:choose>
            
            <xsl:choose>
                <xsl:when test="w:tblPr/w:tblW/@w:type='pct'">
                    <xsl:attribute name="width">100%</xsl:attribute>
                </xsl:when>
            </xsl:choose>
            <tbody>
                <xsl:apply-templates select="w:tr"/>
            </tbody>
        </table>
    </xsl:template>
    
    <xsl:template match="w:tr">
        <tr>
            <xsl:apply-templates select="w:tc"/>
        </tr>
    </xsl:template>
    
    <xsl:template match="w:tc">
        <td>
            <xsl:apply-templates select="w:p"/>
        </td>
    </xsl:template>
</xsl:stylesheet>                        
