/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.docx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.webcontentio.ContentImporter;
import org.ametys.web.repository.content.ModifiableWebContent;
import org.ametys.web.repository.page.ModifiablePage;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocxContentImporter
implements ContentImporter,
Serviceable,
Contextualizable {
    protected ServiceManager _manager;
    private SourceResolver _resolver;
    private DOMParser _domParser;
    private XPathProcessor _xPathProcessor;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._domParser = (DOMParser)manager.lookup(DOMParser.ROLE);
        this._xPathProcessor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importContent(File file, ModifiableWebContent content, Map<String, String> params) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        String template = null;
        String longTitle = null;
        String contentType = null;
        Document document = this._getDocument(zipFile, "word/document.xml", file);
        Document relations = this._getDocument(zipFile, "word/_rels/document.xml.rels", file);
        DocxPrefixResolver resolver = new DocxPrefixResolver(this);
        template = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[1]/w:tr[1]/w:sdt/w:sdtPr[w:tag/@w:val='template']/w:comboBox/w:listItem[@w:displayText=../../../w:sdtContent/w:tc/w:p/w:r/w:t]/@w:value", (PrefixResolver)resolver);
        longTitle = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[1]/w:tr[2]/w:sdt/w:sdtPr[w:tag/@w:val='long_title']/w:text", (PrefixResolver)resolver);
        contentType = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[1]/w:tr[3]/w:sdt/w:sdtPr[w:tag/@w:val='content-type']/w:comboBox/w:listItem[@w:displayText=../../../w:sdtContent/w:tc/w:p/w:r/w:t]/@w:value", (PrefixResolver)resolver);
        String sectionStr = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[2]/w:tr[1]/w:sdt/w:sdtPr[w:tag/@w:val='SECTION']/w:comboBox/w:listItem[@w:displayText=../../../w:sdtContent/w:tc/w:p/w:r/w:t]/@w:value", (PrefixResolver)resolver);
        String directAccessStr = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[2]/w:tr[2]/w:sdt/w:sdtPr[w:tag/@w:val='ACCES_DIRECTS']/w:comboBox/w:listItem[@w:displayText=../../../w:sdtContent/w:tc/w:p/w:r/w:t]/@w:value", (PrefixResolver)resolver);
        String footerStr = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[2]/w:tr[3]/w:sdt/w:sdtPr[w:tag/@w:val='FOOTER_LINK']/w:comboBox/w:listItem[@w:displayText=../../../w:sdtContent/w:tc/w:p/w:r/w:t]/@w:value", (PrefixResolver)resolver);
        String eventStr = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:tbl[2]/w:tr[4]/w:sdt/w:sdtPr[w:tag/@w:val='EVENT']/w:comboBox/w:listItem[@w:displayText=../../../w:sdtContent/w:tc/w:p/w:r/w:t]/@w:value", (PrefixResolver)resolver);
        boolean section = "SECTION".equals(sectionStr);
        boolean directAccess = "ACCES_DIRECTS".equals(directAccessStr);
        boolean footer = "FOOTER_LINK".equals(footerStr);
        boolean event = "EVENT".equals(eventStr);
        NodeList abstractList = this._xPathProcessor.selectNodeList((Node)document, "/w:document/w:body/w:sdt[w:sdtPr/w:tag/@w:val='abstract' and not(w:sdtPr/w:showingPlcHdr)]/w:sdtContent/w:p/w:r/w:t", (PrefixResolver)resolver);
        StringBuilder abstr = new StringBuilder();
        for (int i = 0; i < abstractList.getLength(); ++i) {
            if (i != 0) {
                abstr.append('\n');
            }
            abstr.append(abstractList.item(i).getTextContent());
        }
        String pictureId = this._xPathProcessor.evaluateAsString((Node)document, "/w:document/w:body/w:sdt[w:sdtPr/w:tag/@w:val='illustration' and not(w:sdtPr/w:showingPlcHdr)]/w:sdtContent/w:p/w:r/w:drawing/wp:inline/a:graphic/a:graphicData/pic:pic/pic:blipFill/a:blip/@r:embed", (PrefixResolver)resolver);
        if (StringUtils.trimToNull((String)pictureId) != null) {
            String pictureEntryName = this._xPathProcessor.evaluateAsString((Node)relations, "/rel:Relationships/rel:Relationship[@Id='" + pictureId + "']/@Target", (PrefixResolver)resolver);
            int i = pictureEntryName.lastIndexOf(47);
            String fileName = i == -1 ? pictureEntryName : pictureEntryName.substring(i + 1);
            ZipArchiveEntry entry = zipFile.getEntry("word/" + pictureEntryName);
            try (InputStream is = zipFile.getInputStream(entry);){
                Binary illustration = new Binary();
                illustration.setLastModificationDate(ZonedDateTime.now());
                illustration.setInputStream(is);
                illustration.setFilename(fileName);
                String mimeType = this._context.getMimeType(fileName);
                if (mimeType != null) {
                    illustration.setMimeType(mimeType);
                }
                content.getComposite("illustration", true).setValue("image", (Object)illustration);
            }
        }
        NodeList titleList = this._xPathProcessor.selectNodeList((Node)document, "/w:document/w:body/w:p[w:pPr/w:pStyle/@w:val='Titre'][1]/w:r/w:t", (PrefixResolver)resolver);
        StringBuilder titleBuilder = new StringBuilder();
        for (int j = 0; j < titleList.getLength(); ++j) {
            titleBuilder.append(titleList.item(j).getTextContent());
        }
        params.put("page.template", StringUtils.trimToNull((String)template));
        params.put("page.longTitle", StringUtils.trimToNull((String)longTitle));
        String title = titleBuilder.toString();
        content.setTitle(StringUtils.trimToNull((String)title) != null ? title : content.getName());
        String cType = this._getContentType(contentType);
        content.setTypes(new String[]{cType});
        if (abstr.length() > 0) {
            content.setValue("abstract", (Object)abstr.toString());
        }
        if (section) {
            content.tag("SECTION");
        }
        if (directAccess) {
            content.tag("ACCES_DIRECTS");
        }
        if (footer) {
            content.tag("FOOTER_LINK");
        }
        if (event) {
            content.tag("EVENT");
        }
        HashMap<String, Document> context = new HashMap<String, Document>();
        context.put("document", document);
        context.put("relations", relations);
        context.put("zipFile", (Document)zipFile);
        context.put("content", (Document)content);
        Source src = this._resolver.resolveURI("cocoon:/docx2docbook", null, context);
        try (InputStream is = src.getInputStream();){
            RichText richText = new RichText();
            richText.setLastModificationDate(ZonedDateTime.now());
            richText.setMimeType("text/xml");
            richText.setInputStream(is);
            SAXParser saxParser = null;
            try (InputStream in = richText.getInputStream();){
                saxParser = (SAXParser)this._manager.lookup(SAXParser.ROLE);
                saxParser.parse(new InputSource(in), (ContentHandler)new DefaultHandler());
                content.setValue("content", (Object)richText);
            }
            catch (SAXException e) {
                try {
                    throw new IOException("Invalid resulting XML after transformation", e);
                    catch (ServiceException e2) {
                        throw new IOException("Unable to get a SAX parser.", e2);
                    }
                }
                catch (Throwable throwable) {
                    this._manager.release(saxParser);
                    throw throwable;
                }
            }
            this._manager.release((Object)saxParser);
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
    }

    private String _getContentType(String contentType) {
        return StringUtils.trimToNull((String)contentType) != null ? contentType : "org.ametys.web.default.Content.article";
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document"};
    }

    @Override
    public void postTreatment(ModifiablePage page, Content content, File file) throws IOException {
    }

    private Document _getDocument(ZipFile zipFile, String entryName, File file) throws IOException {
        Document document;
        block8: {
            ZipArchiveEntry entry = zipFile.getEntry(entryName);
            InputStream is = zipFile.getInputStream(entry);
            try {
                document = this._domParser.parseDocument(new InputSource(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXException e) {
                    throw new IOException("Unable to read " + entryName + " in file " + file.getAbsolutePath(), e);
                }
            }
            is.close();
        }
        return document;
    }

    private class DocxPrefixResolver
    implements PrefixResolver {
        private Map<String, String> _ns = new HashMap<String, String>();

        public DocxPrefixResolver(DocxContentImporter docxContentImporter) {
            this._ns.put("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
            this._ns.put("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            this._ns.put("wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
            this._ns.put("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            this._ns.put("pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
            this._ns.put("rel", "http://schemas.openxmlformats.org/package/2006/relationships");
        }

        public String prefixToNamespace(String prefix) {
            return this._ns.get(prefix);
        }
    }
}

