/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.webcontentio;

import java.util.HashMap;
import java.util.Map;

import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

/**
 * Extension point for {@link ContentImporter}.
 */
public class ContentImporterExtensionPoint extends AbstractThreadSafeComponentExtensionPoint<ContentImporter>
{
    /** Avalon Role */
    public static final String ROLE = ContentImporterExtensionPoint.class.getName();
    
    private Map<String, ContentImporter> _importers = new HashMap<>();
    
    /**
     * Returns the {@link ContentImporter} corresponding to a mime type.
     * @param mimeType the content mime type
     * @return the {@link ContentImporter} corresponding to a mime type.
     */
    public ContentImporter getContentImporterForMimeType(String mimeType)
    {
        return _importers.get(mimeType);
    }
    
    @Override
    public void initializeExtensions() throws Exception
    {
        super.initializeExtensions();
        
        for (String id : getExtensionsIds())
        {
            ContentImporter importer = getExtension(id);
            for (String mimeType : importer.getMimeTypes())
            {
                _importers.put(mimeType, importer);
            }
        }
    }
}
