/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.webcontentio.archive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipOutputStream;

import javax.jcr.Node;

import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.web.repository.site.Site;

/**
 * Component responsible to archive site plugin data.
 */
public interface SitePluginArchiver
{
    /**
     * Export plugin data into the destination archive
     * @param site the current site.
     * @param pluginName the plugin name.
     * @param pluginNode the plugin {@link Node}.
     * @param zos the output data stream.
     * @param prefix the prefix for ZIP entries.
     * @throws IOException if an error occurs while writing entries to the archive.
     */
    public void export(Site site, String pluginName, Node pluginNode, ZipOutputStream zos, String prefix) throws IOException;
    
    /**
     * Import plugin data from the source archive
     * @param site the current site.
     * @param pluginName the plugin name.
     * @param allPluginsNode the {@link Node} for all plugins.
     * @param zipPath The input ZIP file
     * @param zipPluginEntryPath The input ZIP entry
     * @param merger The {@link Merger}
     * @return The {@link ImportReport}
     * @throws IOException if an error occurs while reading the archive.
     */
    public ImportReport partialImport(Site site, String pluginName, Node allPluginsNode, Path zipPath, String zipPluginEntryPath, Merger merger) throws IOException;
}
