/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webdeploystarter;

import java.util.HashMap;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.site.SiteConfigurationManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class Init
extends org.ametys.plugins.deploystarter.Init {
    private SiteConfigurationManager _siteConfigurationManager;
    private SiteManager _siteManager;
    private ObservationManager _observationManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        if (!PluginsManager.getInstance().isSafeMode()) {
            this._siteConfigurationManager = (SiteConfigurationManager)manager.lookup(SiteConfigurationManager.ROLE);
            this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
            this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        }
    }

    protected void _act(Configuration configuration) throws Exception {
        super._act(configuration);
        if (!PluginsManager.getInstance().isSafeMode()) {
            this._actSites(configuration.getChild("sites"));
        }
    }

    private void _actSites(Configuration sitesConfiguration) throws Exception {
        this.getLogger().debug("'start actions' acting on sites...");
        UserIdentity adminUser = new UserIdentity("admin", "admin_population");
        for (Configuration siteConfiguration : sitesConfiguration.getChildren("site")) {
            String siteName = siteConfiguration.getAttribute("name");
            Site site = this._siteManager.getSite(siteName);
            if (site == null) {
                throw new ConfigurationException("The site '" + siteName + "' does not exists and thus cannot be edited", siteConfiguration);
            }
            HashMap<String, Site> eventParams = new HashMap<String, Site>();
            eventParams.put("site", site);
            this._observationManager.notify(new Event("site.updating", adminUser, eventParams));
            for (Configuration paramConfiguration : siteConfiguration.getChild("params").getChildren()) {
                ValidationResult validationResult;
                String paramName = paramConfiguration.getName();
                ElementDefinition siteParameter = this._siteConfigurationManager.getSiteParameter(site, paramName);
                ElementType type = siteParameter.getType();
                String untypedValue = paramConfiguration.getValue("");
                Object typedValue = type.castValue((Object)untypedValue);
                Validator validator = siteParameter.getValidator();
                if (validator != null && (validationResult = validator.validate(typedValue)).hasErrors()) {
                    throw new ConfigurationException("Erreur in parameter: " + validationResult.getErrors(), paramConfiguration);
                }
                if (type.getManagedClass() == String.class) {
                    site.setValue(paramName, (Object)(typedValue == null ? "" : (String)typedValue));
                    continue;
                }
                if (type.getManagedClass() == Boolean.class) {
                    site.setValue(paramName, (Object)(typedValue == null ? false : (Boolean)typedValue));
                    continue;
                }
                if (typedValue == null) {
                    site.removeValue(paramName);
                    continue;
                }
                site.setValue(paramName, typedValue);
            }
            this.getLogger().info("'start actions' updated site {}", (Object)siteName);
            site.getNode().getSession().save();
            this._siteConfigurationManager.reloadSiteConfiguration(site);
            this._observationManager.notify(new Event("site.updated", adminUser, eventParams));
        }
    }
}

