/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspacessite;

import java.util.Enumeration;

import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

import org.ametys.plugins.site.proxy.BackOfficeRequestProxy;

/**
 * Handle webdav requests from and to backoffice.
 */
public class WebdavProxy implements BackOfficeRequestProxy
{
    public void prepareBackOfficeRequest(Request request, HttpUriRequest backOfficeRequest)
    {
        String[] headerNames = new String[]{"Lock-Token"};
        
        for (String headerName : headerNames)
        {
            Enumeration<String> headers = request.getHeaders(headerName);
            while (headers.hasMoreElements())
            {
                String value = headers.nextElement();
                backOfficeRequest.addHeader(headerName, value);
            }
        }
    }
    
    public void handleBackOfficeResponse(Response response, HttpResponse backOfficeResponse)
    {
        String[] headerNames = new String[]{"DAV", "Ms-Author-Via", "Lock-Token"};
                
        for (String headerName : headerNames)
        {
            Header[] headers = backOfficeResponse.getHeaders(headerName);
            for (Header header : headers)
            {
                String value = header.getValue();
                response.addHeader(headerName, value);
            }
        }
    }
}
