/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.minisite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;

public class MinisiteActivityType
extends AbstractWorkspacesActivityType {
    public static final String PAGE_TITLE = "pageTitle";
    public static final String PAGE_ID = "pageId";
    public static final String ACTIVITY_CATEGORY_MINISITE = "minisite";

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        activity.setValue("category", (Object)ACTIVITY_CATEGORY_MINISITE);
        Page page = this._getPage(parameters);
        if (page != null) {
            activity.setValue(PAGE_ID, (Object)page.getId());
            activity.setValue(PAGE_TITLE, (Object)page.getTitle());
        } else {
            String pageTitle;
            String pageId = (String)parameters.get("page.id");
            if (pageId != null) {
                activity.setValue(PAGE_ID, (Object)pageId);
            }
            if ((pageTitle = (String)parameters.get("minisite.page.title")) != null) {
                activity.setValue(PAGE_TITLE, (Object)pageTitle);
            }
        }
    }

    private Page _getPage(Map<String, Object> parameters) {
        SitemapElement sitemapElement = (SitemapElement)parameters.get("sitemapelement");
        if (sitemapElement != null && sitemapElement instanceof Page) {
            Page page = (Page)sitemapElement;
            return page;
        }
        return (Page)parameters.get("page");
    }

    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map mergedActivities = super.mergeActivities(activities);
        ArrayList mergedPages = new ArrayList();
        ArrayList<String> knownPages = new ArrayList<String>();
        for (Activity event : activities) {
            String pageId = (String)event.getValue(PAGE_ID);
            if (knownPages.contains(pageId)) continue;
            knownPages.add(pageId);
            HashMap<String, Object> pageInfo = new HashMap<String, Object>();
            pageInfo.put(PAGE_ID, event.getValue(PAGE_ID));
            pageInfo.put(PAGE_TITLE, event.getValue(PAGE_TITLE));
            mergedPages.add(pageInfo);
        }
        mergedActivities.put("pages", mergedPages);
        mergedActivities.put("amount", mergedPages.size());
        return mergedActivities;
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        return new StringExpression(PAGE_TITLE, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        return (Project)((Object)args.get("project"));
    }
}

