/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.cms.repository.comment.CommentableContent;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelLessComposite;
import org.ametys.plugins.workspaces.activities.projects.WebContentActivityType;
import org.ametys.web.repository.content.WebContent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class ContentCommentedActivityType
extends WebContentActivityType {
    public static final String PARENT_COMMENT = "parentComment";
    public static final String COMMENT_DATE = "date";
    public static final String COMMENT_AUTHOR = "author";
    public static final String PARENT_COMMENT_SUMMARY = "summary";
    public static final String COMMENT_ID = "commentId";
    public static final String COMMENT_SUMMARY = "commentSummary";
    private PopulationContextHelper _populationContextHelper;
    private ContentTypesHelper _cTypeHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._populationContextHelper = (PopulationContextHelper)serviceManager.lookup(PopulationContextHelper.ROLE);
        this._cTypeHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
    }

    public boolean support(Event event) {
        return this._isSupportedContentType(event);
    }

    private boolean _isSupportedContentType(Event event) {
        Content content = (Content)event.getArguments().get("content");
        return this._cTypeHelper.isInstanceOf(content, "org.ametys.plugins.workspaces.Content.wallContent") || this._cTypeHelper.isInstanceOf(content, "org.ametys.plugins.workspaces.Content.projectNews");
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        CommentableContent content = (CommentableContent)parameters.get("content");
        activity.setValue("contentCreator", (Object)content.getCreator());
        activity.setValue("contentCreationDate", (Object)content.getCreationDate());
        Comment comment = (Comment)parameters.get("comment");
        String id = comment.getId();
        if (comment.isSubComment()) {
            Comment parentComment = comment.getCommentParent();
            ModifiableModelLessComposite activityParentComment = activity.getComposite(PARENT_COMMENT, true);
            activityParentComment.setValue(COMMENT_SUMMARY, (Object)StringUtils.abbreviate((String)parentComment.getContent(), (String)"\u2026", (int)150));
            WebContent web = (WebContent)content;
            String siteName = web.getSite().getName();
            Set userPopulationsOnSite = this._populationContextHelper.getUserPopulationsOnContexts(Arrays.asList("/sites/" + siteName, "/sites-fo/" + siteName), false, false);
            try {
                User author = this._userManager.getUserByEmail(userPopulationsOnSite, parentComment.getAuthorEmail());
                activityParentComment.setValue(COMMENT_AUTHOR, (Object)author.getIdentity());
            }
            catch (NotUniqueUserException e) {
                activityParentComment.setValue("author_fullName", (Object)parentComment.getAuthorName());
            }
            activityParentComment.setValue(COMMENT_DATE, (Object)parentComment.getCreationDate());
            activityParentComment.setValue(COMMENT_ID, (Object)parentComment.getId());
        }
        activity.setValue(COMMENT_ID, (Object)id);
        activity.setValue(COMMENT_SUMMARY, (Object)StringUtils.abbreviate((String)comment.getContent(), (String)"\u2026", (int)150));
    }
}

