/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.calendars.AbstractCalendarDAO;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarColorsComponent;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.ModifiableCalendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventJSONHelper;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendar;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;

public class CalendarDAO
extends AbstractCalendarDAO {
    public static final String ROLE = CalendarDAO.class.getName();
    protected CalendarEventJSONHelper _calendarEventJSONHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._calendarEventJSONHelper = (CalendarEventJSONHelper)((Object)manager.lookup(CalendarEventJSONHelper.ROLE));
    }

    public Map<String, Object> getCalendarData(Calendar calendar, boolean recursive, boolean includeEvents, boolean useICSFormat) {
        AmetysObjectIterable children;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", calendar.getId());
        result.put("title", Text.unescapeIllegalJcrChars((String)calendar.getName()));
        result.put("description", calendar.getDescription());
        result.put("templateDesc", calendar.getTemplateDescription());
        result.put("color", calendar.getColor());
        result.put("visibility", calendar.getVisibility().name().toLowerCase());
        result.put("public", calendar.getVisibility() == Calendar.CalendarVisibility.PUBLIC);
        result.put("workflowName", calendar.getWorkflowName());
        if (recursive) {
            LinkedList<Map<String, Object>> calendarList = new LinkedList<Map<String, Object>>();
            result.put("calendars", calendarList);
            children = calendar.getChildren();
            for (AmetysObject child : children) {
                if (!(child instanceof Calendar)) continue;
                calendarList.add(this.getCalendarData((Calendar)child, recursive, includeEvents, useICSFormat));
            }
        }
        if (includeEvents) {
            LinkedList<Map<String, Object>> eventList = new LinkedList<Map<String, Object>>();
            result.put("events", eventList);
            children = calendar.getChildren();
            for (AmetysObject child : children) {
                if (!(child instanceof CalendarEvent)) continue;
                eventList.add(this._calendarEventJSONHelper.eventAsJson((CalendarEvent)child, false, useICSFormat));
            }
        }
        result.put("rights", this._extractCalendarRightData(calendar));
        result.put("token", this.getCalendarIcsToken(calendar, true));
        return result;
    }

    public Map<String, Object> getCalendarProperties(Calendar calendar) {
        return this.getCalendarData(calendar, false, false, false);
    }

    @Callable
    public Map<String, Object> addCalendar(String inputName, String color, boolean isPublic) throws IllegalAccessException {
        String rootId = this._getCalendarRoot().getId();
        return this.addCalendar(rootId, inputName, "", "", color, isPublic ? Calendar.CalendarVisibility.PUBLIC.name() : Calendar.CalendarVisibility.PRIVATE.name(), "calendar-default", false);
    }

    public Map<String, Object> addCalendar(String id, String inputName, String description, String templateDesc, String color, String visibility, String workflowName, Boolean renameIfExists) throws IllegalAccessException {
        return this.addCalendar((ModifiableTraversableAmetysObject)this._resolver.resolveById(id), inputName, description, templateDesc, color, visibility, workflowName, renameIfExists, true, true);
    }

    public Map<String, Object> addCalendar(ModifiableTraversableAmetysObject parent, String inputName, String description, String templateDesc, String color, String visibility, String workflowName, Boolean renameIfExists, Boolean checkRights, boolean notify) throws IllegalAccessException {
        String originalName = Text.escapeIllegalJcrChars((String)inputName);
        if (checkRights.booleanValue()) {
            this._explorerResourcesDAO.checkUserRight((AmetysObject)parent, "Plugins_Workspaces_Calendar_Add");
        }
        if (BooleanUtils.isNotTrue((Boolean)renameIfExists) && parent.hasChild(originalName)) {
            this.getLogger().warn("Cannot create the calendar with name '" + originalName + "', an object with same name already exists.");
            return Map.of("message", "already-exist");
        }
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)parent)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to modify the object '" + parent.getName() + "' but it is locked by another user");
            return Map.of("message", "locked");
        }
        int index = 2;
        Object name = originalName;
        while (parent.hasChild((String)name)) {
            name = originalName + " (" + index + ")";
            ++index;
        }
        JCRCalendar calendar = (JCRCalendar)parent.createChild((String)name, "ametys:calendar");
        calendar.setWorkflowName(workflowName);
        calendar.setDescription(description);
        calendar.setTemplateDescription(templateDesc);
        calendar.setColor(color);
        calendar.setVisibility(StringUtils.isNotEmpty((CharSequence)visibility) ? Calendar.CalendarVisibility.valueOf(visibility.toUpperCase()) : Calendar.CalendarVisibility.PRIVATE);
        parent.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("object.id", calendar.getId());
        eventParams.put("object.parent", parent.getId());
        eventParams.put("object.name", name);
        eventParams.put("object.path", calendar.getPath());
        if (notify) {
            this._observationManager.notify(new Event("calendar.created", this._currentUserProvider.getUser(), eventParams));
        }
        return this.getCalendarProperties(calendar);
    }

    @Callable
    public Map<String, Object> editCalendar(String id, String inputName, String templateDesc, String color, boolean isPublic) throws IllegalAccessException {
        Calendar.CalendarVisibility visibility;
        Calendar.CalendarVisibility calendarVisibility = visibility = isPublic ? Calendar.CalendarVisibility.PUBLIC : Calendar.CalendarVisibility.PRIVATE;
        assert (id != null);
        String rename = Text.escapeIllegalJcrChars((String)inputName);
        AmetysObject object = this._resolver.resolveById(id);
        if (!(object instanceof ModifiableCalendar)) {
            throw new IllegalClassException(ModifiableCalendar.class, object.getClass());
        }
        ModifiableCalendar calendar = (ModifiableCalendar)object;
        this._explorerResourcesDAO.checkUserRight(object, "Plugins_Workspaces_Calendar_Edit");
        Object name = calendar.getName();
        ModifiableTraversableAmetysObject parent = (ModifiableTraversableAmetysObject)calendar.getParent();
        if (!StringUtils.equals((CharSequence)rename, (CharSequence)name) && parent.hasChild(rename)) {
            this.getLogger().warn("Cannot edit the calendar with the new name '" + inputName + "', an object with same name already exists.");
            return Map.of("message", "already-exist");
        }
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)calendar)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to modify calendar '" + object.getName() + "' but it is locked by another user");
            return Map.of("message", "locked");
        }
        if (!StringUtils.equals((CharSequence)name, (CharSequence)rename)) {
            int index = 2;
            name = Text.escapeIllegalJcrChars((String)rename);
            while (parent.hasChild((String)name)) {
                name = rename + " (" + index + ")";
                ++index;
            }
            calendar.rename((String)name);
        }
        calendar.setTemplateDescription(templateDesc);
        calendar.setColor(color);
        calendar.setVisibility(visibility);
        parent.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("object.id", calendar.getId());
        eventParams.put("object.parent", parent.getId());
        eventParams.put("object.name", name);
        eventParams.put("object.path", calendar.getPath());
        this._observationManager.notify(new Event("calendar.updated", this._currentUserProvider.getUser(), eventParams));
        return this.getCalendarProperties(calendar);
    }

    @Callable
    public Map<String, Object> deleteCalendar(String id) throws IllegalAccessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        assert (id != null);
        AmetysObject object = this._resolver.resolveById(id);
        if (!(object instanceof ModifiableCalendar)) {
            throw new IllegalClassException(ModifiableCalendar.class, object.getClass());
        }
        ModifiableCalendar calendar = (ModifiableCalendar)object;
        this._explorerResourcesDAO.checkUserRight(object, "Plugins_Workspaces_Calendar_Delete");
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)calendar)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to delete calendar'" + object.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        ModifiableExplorerNode parent = (ModifiableExplorerNode)calendar.getParent();
        String parentId = parent.getId();
        String name = calendar.getName();
        String path = calendar.getPath();
        calendar.remove();
        parent.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", id);
        eventParams.put("object.parent", parentId);
        eventParams.put("object.name", name);
        eventParams.put("object.path", path);
        this._observationManager.notify(new Event("calendar.deleted", this._currentUserProvider.getUser(), eventParams));
        result.put("id", id);
        result.put("parentId", parentId);
        return result;
    }

    public String getCalendarIcsToken(Calendar calendar, boolean createIfNotExisting) {
        String token = calendar.getIcsUrlToken();
        if (createIfNotExisting && token == null && calendar instanceof ModifiableCalendar) {
            token = UUID.randomUUID().toString();
            ((ModifiableCalendar)calendar).setIcsUrlToken(token);
            ((ModifiableCalendar)calendar).saveChanges();
        }
        return token;
    }

    public Calendar getCalendarFromIcsToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        StringExpression expr = new StringExpression("ics-token", Expression.Operator.EQ, token);
        String calendarsQuery = QueryHelper.getXPathQuery(null, (String)"ametys:calendar", (Expression)expr);
        AmetysObjectIterable calendars = this._resolver.query(calendarsQuery);
        AmetysObjectIterator calendarsIterator = calendars.iterator();
        if (calendarsIterator.getSize() > 0L) {
            return (Calendar)calendarsIterator.next();
        }
        return null;
    }

    protected Map<String, Object> _extractCalendarRightData(Calendar calendar) {
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("add-event", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Add", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("edit", this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Edit", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Delete", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    @Callable
    public List<Map<String, Object>> getCalendars() {
        ArrayList<Map<String, Object>> calendarsData = new ArrayList<Map<String, Object>>();
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        AmetysObjectIterable<Calendar> calendars = calendarModule.getCalendars(this._getProject());
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                if (!calendarModule.canView(calendar)) continue;
                calendarsData.add(this.getCalendarProperties(calendar));
            }
        }
        return calendarsData;
    }

    @Callable
    public Map<String, CalendarColorsComponent.CalendarColor> getColors() {
        return this._calendarColors.getColors();
    }

    @Callable
    public Map<String, Object> getUserRights() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ModifiableTraversableAmetysObject calendarRoot = this._getCalendarRoot();
        UserIdentity user = this._currentUserProvider.getUser();
        results.put("canCreateCalendar", this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Add", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canEditCalendar", this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Edit", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canRemoveCalendar", this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Delete", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canCreateEvent", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Add", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canEditEvent", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Edit", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canRemoveAnyEvent", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Delete", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canRemoveSelfEvent", this._rightManager.hasRight(user, "Plugins_Workspaces_Owned_Event_Delete", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canCreateTags", this._rightManager.hasRight(user, "Plugins_Workspaces_Rights_Project_Add_Tag", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canHandleResource", this._rightManager.hasRight(user, "Plugins_Workspaces_Handle_Resource", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canBookResource", this._rightManager.hasRight(user, "Plugins_Workspaces_Book_Resource", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("sharePrivateCalendar", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Edit", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        return results;
    }

    protected ModifiableTraversableAmetysObject _getCalendarRoot() {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        return calendarModule.getCalendarsRoot(this._getProject(), true);
    }

    @Callable
    public Map<String, Object> getResourceCalendar() {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        Calendar calendar = calendarModule.getResourceCalendar(this._getProject());
        return this.getCalendarProperties(calendar);
    }
}

