/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.events;

import com.opensymphony.workflow.WorkflowException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.plugins.workspaces.calendars.AbstractCalendarDAO;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.ModifiableCalendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventJSONHelper;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.calendars.events.ModifiableCalendarEvent;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendar;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarEvent;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.workflow.AbstractNodeWorkflowComponent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.StringUtils;

public class CalendarEventDAO
extends AbstractCalendarDAO {
    public static final String ROLE = CalendarEventDAO.class.getName();
    protected CalendarEventJSONHelper _calendarEventJSONHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._calendarEventJSONHelper = (CalendarEventJSONHelper)((Object)manager.lookup(CalendarEventJSONHelper.ROLE));
    }

    @Callable
    public List<Map<String, Object>> getEvents(String startDateAsStr, String endDateAsStr) {
        ZonedDateTime startDate = startDateAsStr != null ? DateUtils.parseZonedDateTime((String)startDateAsStr) : null;
        ZonedDateTime endDate = endDateAsStr != null ? DateUtils.parseZonedDateTime((String)endDateAsStr) : null;
        return this.getEvents(startDate, endDate).stream().map(event -> {
            Map<String, Object> eventData = this._calendarEventJSONHelper.eventAsJson((CalendarEvent)event, false, false);
            ArrayList<Map<String, Object>> occurrencesDataList = new ArrayList<Map<String, Object>>();
            eventData.put("occurrences", occurrencesDataList);
            List<CalendarEventOccurrence> occurrences = event.getOccurrences(startDate, endDate);
            for (CalendarEventOccurrence occurrence : occurrences) {
                occurrencesDataList.add(occurrence.toJSON());
            }
            return eventData;
        }).collect(Collectors.toList());
    }

    public List<CalendarEvent> getEvents(ZonedDateTime startDate, ZonedDateTime endDate) {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        Project project = this._getProject();
        AmetysObjectIterable<Calendar> calendars = calendarModule.getCalendars(project);
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                if (!calendarModule.canView(calendar)) continue;
                for (Map.Entry<CalendarEvent, List<CalendarEventOccurrence>> entry : calendar.getEvents(startDate, endDate).entrySet()) {
                    CalendarEvent event = entry.getKey();
                    eventList.add(event);
                }
            }
        }
        Calendar resourceCalendar = calendarModule.getResourceCalendar(this._getProject());
        for (Map.Entry<CalendarEvent, List<CalendarEventOccurrence>> entry : resourceCalendar.getEvents(startDate, endDate).entrySet()) {
            CalendarEvent event = entry.getKey();
            eventList.add(event);
        }
        return eventList;
    }

    @Callable
    public Map<String, Object> deleteEvent(String id, String occurrence, String choice) throws IllegalAccessException {
        ModifiableCalendar calendar;
        ModifiableCalendarEvent event;
        AmetysObject object;
        HashMap<String, Object> result;
        block8: {
            if (!"unit".equals(choice)) {
                JCRCalendarEvent event2 = (JCRCalendarEvent)this._resolver.resolveById(id);
                this._messagingConnectorCalendarManager.deleteEvent(event2);
            }
            result = new HashMap<String, Object>();
            assert (id != null);
            object = this._resolver.resolveById(id);
            if (!(object instanceof ModifiableCalendarEvent)) {
                throw new IllegalClassException(ModifiableCalendarEvent.class, object.getClass());
            }
            event = (ModifiableCalendarEvent)object;
            calendar = (ModifiableCalendar)event.getParent();
            try {
                this._explorerResourcesDAO.checkUserRight((AmetysObject)calendar, "Plugins_Workspaces_Event_Delete");
            }
            catch (IllegalAccessException e) {
                boolean hasOwnDeleteRight;
                UserIdentity user = this._currentUserProvider.getUser();
                UserIdentity creator = event.getCreator();
                RightManager.RightResult rightCreator = this._rightManager.hasRight(user, "Plugins_Workspaces_Owned_Event_Delete", (Object)calendar);
                boolean bl = hasOwnDeleteRight = rightCreator == RightManager.RightResult.RIGHT_ALLOW && creator.equals((Object)user);
                if (hasOwnDeleteRight) break block8;
                throw e;
            }
        }
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)event)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to delete event'" + object.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        String parentId = calendar.getId();
        String name = event.getName();
        String path = event.getPath();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("calendar", calendar);
        eventParams.put("object.id", id);
        eventParams.put("object.name", name);
        eventParams.put("object.path", path);
        eventParams.put("calendar.event", event);
        if (StringUtils.isNotBlank((CharSequence)choice) && choice.equals("unit")) {
            ArrayList<ZonedDateTime> excludedOccurrences = new ArrayList<ZonedDateTime>();
            excludedOccurrences.addAll(event.getExcludedOccurences());
            ZonedDateTime occurrenceDate = DateUtils.parseZonedDateTime((String)occurrence).withZoneSameInstant(event.getZone());
            excludedOccurrences.add(occurrenceDate.truncatedTo(ChronoUnit.DAYS));
            this._observationManager.notify(new Event("calendar.event.deleting", this._currentUserProvider.getUser(), eventParams));
            event.setExcludedOccurrences(excludedOccurrences);
        } else {
            this._observationManager.notify(new Event("calendar.event.deleting", this._currentUserProvider.getUser(), eventParams));
            event.remove();
        }
        calendar.saveChanges();
        result.put("id", id);
        result.put("parentId", parentId);
        eventParams = new HashMap();
        eventParams.put("object.id", id);
        this._observationManager.notify(new Event("calendar.event.deleted", this._currentUserProvider.getUser(), eventParams));
        return result;
    }

    @Callable
    public Map<String, Object> addEvent(Map<String, Object> parameters, String calendarViewStartDateAsStr, String calendarViewEndDateAsStr) throws WorkflowException, IllegalAccessException {
        ZonedDateTime calendarViewStartDate = calendarViewStartDateAsStr != null ? DateUtils.parseZonedDateTime((String)calendarViewStartDateAsStr) : null;
        ZonedDateTime calendarViewEndDate = calendarViewEndDateAsStr != null ? DateUtils.parseZonedDateTime((String)calendarViewEndDateAsStr) : null;
        Map<String, Object> result = this.doWorkflowEventAction(parameters);
        String eventId = (String)result.get("id");
        this._messagingConnectorCalendarManager.addEventInvitation(parameters, eventId);
        this._projectManager.getProjectsRoot().saveChanges();
        JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById((String)result.get("id"));
        Map<String, Object> eventDataWithFilteredOccurences = this._calendarEventJSONHelper.eventAsJsonWithOccurrences(event, false, calendarViewStartDate, calendarViewEndDate);
        result.put("eventDataWithFilteredOccurences", eventDataWithFilteredOccurences);
        return result;
    }

    @Callable
    public Map<String, Object> editEvent(Map<String, Object> parameters, String calendarViewStartDateAsStr, String calendarViewEndDateAsStr) throws WorkflowException {
        ZonedDateTime calendarViewStartDate = calendarViewStartDateAsStr != null ? DateUtils.parseZonedDateTime((String)calendarViewStartDateAsStr) : null;
        ZonedDateTime calendarViewEndDate = calendarViewEndDateAsStr != null ? DateUtils.parseZonedDateTime((String)calendarViewEndDateAsStr) : null;
        String eventId = (String)parameters.get("id");
        JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById(eventId);
        String previousCalendarId = event.getParent().getId();
        String parentId = (String)parameters.get("parentId");
        if (previousCalendarId != null && !StringUtils.equals((CharSequence)parentId, (CharSequence)previousCalendarId)) {
            JCRCalendar parentCalendar = (JCRCalendar)this._resolver.resolveById(parentId);
            this.move(event, parentCalendar);
        }
        Map<String, Object> result = this.doWorkflowEventAction(parameters);
        String choice = (String)parameters.get("choice");
        if (!"unit".equals(choice)) {
            this._messagingConnectorCalendarManager.editEventInvitation(parameters, eventId);
        }
        this._projectManager.getProjectsRoot().saveChanges();
        Map<String, Object> oldEventData = this._calendarEventJSONHelper.eventAsJsonWithOccurrences(event, false, calendarViewStartDate, calendarViewEndDate);
        JCRCalendarEvent newEvent = (JCRCalendarEvent)this._resolver.resolveById((String)result.get("id"));
        Map<String, Object> newEventData = this._calendarEventJSONHelper.eventAsJsonWithOccurrences(newEvent, false, calendarViewStartDate, calendarViewEndDate);
        result.put("oldEventData", oldEventData);
        result.put("newEventData", newEventData);
        return result;
    }

    public void move(JCRCalendarEvent event, JCRCalendar parent) throws AmetysRepositoryException {
        try {
            event.getNode().getSession().move(event.getNode().getPath(), parent.getNode().getPath() + "/ametys:calendar-event");
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)event);
            String previousWorkflowName = workflow.getWorkflowName(event.getWorkflowId());
            String workflowName = parent.getWorkflowName();
            if (!StringUtils.equals((CharSequence)previousWorkflowName, (CharSequence)workflowName)) {
                HashMap<String, JCRCalendar> inputs = new HashMap<String, JCRCalendar>();
                inputs.put(AbstractNodeWorkflowComponent.EXPLORERNODE_KEY, parent);
                workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)event);
                long workflowId = workflow.initialize(workflowName, 0, inputs);
                event.setWorkflowId(workflowId);
            }
        }
        catch (WorkflowException | RepositoryException e) {
            String errorMsg = String.format("Fail to move the event '%s' to the calendar '%s'.", event.getId(), parent.getId());
            throw new AmetysRepositoryException(errorMsg, e);
        }
    }

    @Callable
    public Map<String, Object> doWorkflowEventAction(Map<String, Object> parameters) throws WorkflowException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("parameters", parameters);
        inputs.put("result", result);
        String eventId = (String)parameters.get("id");
        Long workflowInstanceId = null;
        CalendarEvent event = null;
        if (StringUtils.isNotEmpty((CharSequence)eventId)) {
            event = (CalendarEvent)this._resolver.resolveById(eventId);
            workflowInstanceId = event.getWorkflowId();
        }
        inputs.put("eventId", eventId);
        Calendar calendar = null;
        String calendarId = (String)parameters.get("parentId");
        if (StringUtils.isNotEmpty((CharSequence)calendarId)) {
            calendar = (Calendar)this._resolver.resolveById(calendarId);
        } else if (event != null) {
            calendar = (Calendar)event.getParent();
        } else {
            throw new WorkflowException("Unable to retrieve the current calendar");
        }
        inputs.put(AbstractNodeWorkflowComponent.EXPLORERNODE_KEY, calendar);
        String workflowName = calendar.getWorkflowName();
        if (workflowName == null) {
            throw new IllegalArgumentException("The workflow name is not specified");
        }
        int actionId = (Integer)parameters.get("actionId");
        boolean sendMail = true;
        String choice = (String)parameters.get("choice");
        if (actionId == 2 && "unit".equals(choice)) {
            sendMail = false;
        }
        inputs.put("sendMail", sendMail);
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)(event != null ? event : null));
        if (workflowInstanceId == null) {
            try {
                workflow.initialize(workflowName, actionId, inputs);
            }
            catch (WorkflowException e) {
                this.getLogger().error("An error occured while creating workflow '" + workflowName + "' with action '" + actionId, (Throwable)e);
                throw e;
            }
        }
        try {
            workflow.doAction(workflowInstanceId.longValue(), actionId, inputs);
        }
        catch (WorkflowException e) {
            this.getLogger().error("An error occured while doing action '" + actionId + "'with the workflow '" + workflowName, (Throwable)e);
            throw e;
        }
        return result;
    }
}

