/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.ModifiableCalendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.ModifiableCalendarEvent;
import org.ametys.plugins.workspaces.calendars.workflow.AddEventFunction;
import org.ametys.plugins.workspaces.workflow.AbstractNodeWorkflowComponent;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.IllegalClassException;

public class EditEventFunction
extends AddEventFunction {
    protected WorkflowProvider _workflowProvider;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
    }

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Map jsParameters = (Map)transientVars.get("parameters");
        if (jsParameters == null) {
            throw new WorkflowException("no parameters defined");
        }
        String eventId = (String)jsParameters.get("id");
        CalendarEvent event = (CalendarEvent)this._resolver.resolveById(eventId);
        String parentId = (String)jsParameters.get("parentId");
        Calendar calendar = (Calendar)this._resolver.resolveById(parentId);
        if (!(calendar instanceof ModifiableCalendar)) {
            throw new IllegalClassException(ModifiableCalendar.class, calendar.getClass());
        }
        if (!(event instanceof ModifiableCalendarEvent)) {
            throw new IllegalClassException(ModifiableCalendarEvent.class, event.getClass());
        }
        ModifiableCalendarEvent mEvent = (ModifiableCalendarEvent)event;
        ModifiableCalendar mCalendar = (ModifiableCalendar)calendar;
        String choice = (String)jsParameters.get("choice");
        Map result = (Map)transientVars.get("result");
        if ("unit".equals(choice)) {
            this._createEventFromOccurrence(mEvent, mCalendar, transientVars, jsParameters);
            String occurrenceDateAsString = (String)jsParameters.get("occurrenceDate");
            ZonedDateTime occurrenceDate = DateUtils.parseZonedDateTime((String)occurrenceDateAsString);
            this._excludeOccurrence(mEvent, occurrenceDate);
            mEvent.saveChanges();
            this._notifyListeners(mEvent);
        } else {
            assert (parentId != null);
            AmetysObject object = this._resolver.resolveById(parentId);
            if (!(object instanceof ModifiableCalendar)) {
                throw new IllegalClassException(ModifiableCalendar.class, object.getClass());
            }
            long workflowId = ((WorkflowEntry)transientVars.get("entry")).getId();
            event.setWorkflowId(workflowId);
            ZonedDateTime[] dates = this._computeEventDates(event, jsParameters);
            this._setEventData(mEvent, transientVars, jsParameters);
            mEvent.setStartDate(dates[0]);
            mEvent.setEndDate(dates[1]);
            mEvent.saveChanges();
            result.put("id", event.getId());
            result.put("parentId", parentId);
            result.put("event", this._calendarEventJSONHelper.eventAsJsonWithOccurrences(event, false, event.getStartDate(), event.getEndDate()));
            this._notifyListeners(mEvent);
        }
    }

    protected void _createEventFromOccurrence(CalendarEvent initialEvent, Calendar parentCalendar, Map transientVars, Map<String, Object> jsParameters) {
        Map result = (Map)transientVars.get("result");
        if (!jsParameters.containsKey("title")) {
            jsParameters.put("title", initialEvent.getTitle());
            jsParameters.put("desc", initialEvent.getDescription());
            jsParameters.put("fullDay", initialEvent.getFullDay());
        }
        jsParameters.put("recurrenceType", EventRecurrenceTypeEnum.NEVER.toString());
        jsParameters.put("untilDate", null);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("parameters", jsParameters);
        inputs.put(AbstractNodeWorkflowComponent.EXPLORERNODE_KEY, parentCalendar);
        inputs.put("result", result);
        String workflowName = parentCalendar.getWorkflowName();
        try {
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
            workflow.initialize(workflowName, 1, inputs);
        }
        catch (WorkflowException e) {
            throw new AmetysRepositoryException("Unable to create a new event with workflow '" + workflowName + "' and action 1'", (Throwable)e);
        }
    }

    protected void _excludeOccurrence(ModifiableCalendarEvent event, ZonedDateTime occurrenceDate) {
        ArrayList<ZonedDateTime> excludedOccurrences = new ArrayList<ZonedDateTime>(event.getExcludedOccurences());
        excludedOccurrences.add(occurrenceDate.truncatedTo(ChronoUnit.DAYS));
        event.setExcludedOccurrences(excludedOccurrences);
    }

    protected ZonedDateTime[] _computeEventDates(CalendarEvent event, Map<String, Object> jsParameters) {
        String occurrenceDateAsString = (String)jsParameters.get("occurrenceDate");
        ZonedDateTime occurrenceDate = DateUtils.parseZonedDateTime((String)occurrenceDateAsString);
        long oldDiff = ChronoUnit.SECONDS.between(event.getStartDate(), event.getEndDate());
        ZonedDateTime occurrenceEndDate = occurrenceDate.plusSeconds(oldDiff);
        String startDateAsString = (String)jsParameters.get("startDate");
        ZonedDateTime startDate = DateUtils.parseZonedDateTime((String)startDateAsString);
        String endDateAsString = (String)jsParameters.get("endDate");
        ZonedDateTime endDate = DateUtils.parseZonedDateTime((String)endDateAsString);
        long startDiff = ChronoUnit.SECONDS.between(occurrenceDate, startDate);
        long endDiff = ChronoUnit.SECONDS.between(occurrenceEndDate, endDate);
        return new ZonedDateTime[]{event.getStartDate().plusSeconds(startDiff), event.getEndDate().plusSeconds(endDiff)};
    }

    @Override
    protected void _notifyListeners(CalendarEvent event) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("calendar", event.getParent());
        eventParams.put("calendar.event", event);
        eventParams.put("object.id", event.getId());
        eventParams.put("object.parent", event.getParent().getId());
        this._observationManager.notify(new Event("calendar.event.updated", this._currentUserProvider.getUser(), eventParams));
    }

    @Override
    public I18nizableText getLabel() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_EDIT_EVENT_FUNCTION_LABEL");
    }
}

